/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.common.tests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.ModulePropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTest
extends TestCase {
    public static String DB_DRIVER = "org.jboss.esb.test.db.driver";
    public static String DB_URL = "org.jboss.esb.test.db.url";
    public static String DB_USERNAME = "org.jboss.esb.test.db.user";
    public static String DB_PASSWORD = "org.jboss.esb.test.db.password";
    public static String FTP_HOSTNAME = "org.jboss.esb.test.ftp.hostname";
    public static String FTP_USER = "org.jboss.esb.test.ftp.user";
    public static String FTP_DIR = "org.jboss.esb.test.ftp.dir";
    public static String FTP_PWD = "org.jboss.esb.test.ftp.pwd";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    public static HashMap<String, String> SYSTEM_PARAMETERS;

    public BaseTest() {
        super("DummyName");
        SYSTEM_PARAMETERS = this.readSystemParameters();
    }

    public BaseTest(String name) {
        super(name);
        SYSTEM_PARAMETERS = this.readSystemParameters();
    }

    private HashMap<String, String> readSystemParameters() {
        String dbDriver = ModulePropertyManager.getPropertyManager((String)"connection").getProperty(DB_DRIVER, "org.hsqldb.jdbcDriver");
        String dbUrl = ModulePropertyManager.getPropertyManager((String)"connection").getProperty(DB_URL, "jdbc:hsqldb:.");
        String dbUsername = ModulePropertyManager.getPropertyManager((String)"connection").getProperty(DB_USERNAME, "sa");
        String dbPassword = ModulePropertyManager.getPropertyManager((String)"connection").getProperty(DB_PASSWORD, "");
        String ftpHostname = ModulePropertyManager.getPropertyManager((String)"connection").getProperty(FTP_HOSTNAME, "localhost:10021");
        String ftpUser = ModulePropertyManager.getPropertyManager((String)"connection").getProperty(FTP_USER, "anonymous");
        String ftpDir = ModulePropertyManager.getPropertyManager((String)"connection").getProperty(FTP_DIR, "/pub/DNS");
        String ftpPwd = ModulePropertyManager.getPropertyManager((String)"connection").getProperty(FTP_PWD, "");
        HashMap<String, String> systemParameters = new HashMap<String, String>();
        systemParameters.put(DB_DRIVER, dbDriver);
        systemParameters.put(DB_URL, dbUrl);
        systemParameters.put(DB_USERNAME, dbUsername);
        systemParameters.put(DB_PASSWORD, dbPassword);
        systemParameters.put(FTP_HOSTNAME, ftpHostname);
        systemParameters.put(FTP_USER, ftpUser);
        systemParameters.put(FTP_DIR, ftpDir);
        systemParameters.put(FTP_PWD, ftpPwd);
        this.log.debug((Object)"DB parameters:");
        this.log.debug((Object)("Driver=" + dbDriver));
        this.log.debug((Object)("url=" + dbUrl));
        this.log.debug((Object)("username=" + dbUsername));
        this.log.debug((Object)("password=" + dbPassword));
        this.log.debug((Object)"FTP parameters:");
        this.log.debug((Object)("Hostname=" + ftpHostname));
        this.log.debug((Object)("User=" + ftpUser));
        this.log.debug((Object)("Dir=" + ftpDir));
        this.log.debug((Object)("Password=" + ftpPwd));
        return systemParameters;
    }

    protected String getDbUrl() {
        return SYSTEM_PARAMETERS.get(DB_URL);
    }

    protected String getDbUser() {
        return SYSTEM_PARAMETERS.get(DB_USERNAME);
    }

    protected String getDbPassword() {
        return SYSTEM_PARAMETERS.get(DB_PASSWORD);
    }

    protected String getDbDriver() {
        return SYSTEM_PARAMETERS.get(DB_DRIVER);
    }

    protected String getFtpHostname() {
        return SYSTEM_PARAMETERS.get(FTP_HOSTNAME);
    }

    protected String getFtpUser() {
        return SYSTEM_PARAMETERS.get(FTP_USER);
    }

    protected String getFtpDir() {
        return SYSTEM_PARAMETERS.get(FTP_DIR);
    }

    protected String getFtpPwd() {
        return SYSTEM_PARAMETERS.get(FTP_PWD);
    }

    public Connection getDbConnection() throws SQLException {
        this.registerJdbcDriver();
        return DriverManager.getConnection(this.getDbUrl(), this.getDbUser(), this.getDbPassword());
    }

    public Connection getDbConnection(String username, String password) throws SQLException {
        this.registerJdbcDriver();
        return DriverManager.getConnection(this.getDbUrl(), username, password);
    }

    public void setObjStoreConfigFile(String filePath) {
        if (filePath == null) {
            ModulePropertyManager.getPropertyManager((String)"core").getProperties().remove("org.jboss.soa.esb.objStore.configFile");
        } else {
            ModulePropertyManager.getPropertyManager((String)"core").setProperty("org.jboss.soa.esb.objStore.configFile", filePath);
        }
    }

    private void registerJdbcDriver() {
        try {
            Class.forName(this.getDbDriver()).newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            BaseTest.fail((String)("JDBC Driver [" + this.getDbDriver() + "] not available in classpath."));
        }
    }
}

