/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.tools.FileUtil;
import org.jbpm.bpel.wsdl.util.WsdlServiceGenerator;
import org.jbpm.bpel.xml.ProblemCounter;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.jpdl.xml.Problem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebModuleGenerator {
    private File outputDirectory = tmpDir;
    private String moduleName;
    private String packagePrefix = "org.example";
    private ProblemHandler problemHandler = new ProblemCounter();
    static final String NS_WSCOMPILE = "http://java.sun.com/xml/ns/jax-rpc/ri/config";
    static final String ELEM_CONFIGURATION = "configuration";
    static final String ELEM_WSDL = "wsdl";
    static final String ATTR_LOCATION = "location";
    static final String ATTR_PACKAGE_NAME = "packageName";
    static final String DEFAULT_PACKAGE_PREFIX = "org.example";
    static final String DIR_WSDL = "wsdl";
    static final String DIR_WEB_INF = "WEB-INF";
    static final String DIR_CLASSES = "classes";
    static final char SEPARATOR = '/';
    private static final String WSCOMPILE_CP_PROPERTY = "wscompile.class.path";
    private static final Log log = LogFactory.getLog((Class)WebModuleGenerator.class);
    private static final File tmpDir = new File(System.getProperty("java.io.tmpdir"));
    private static final String wscompileClassPath = WebModuleGenerator.getWscompileClassPath();

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    public void setProblemHandler(ProblemHandler problemHandler) {
        if (problemHandler == null) {
            throw new IllegalArgumentException("problem handler cannot be null");
        }
        this.problemHandler = problemHandler;
    }

    public void generateWebModule(BpelProcessDefinition processDefinition) {
        if (this.moduleName == null) {
            this.moduleName = WebModuleGenerator.toLowerCaseJavaIdentifier(processDefinition.getName());
        }
        this.callWsdlServiceGenerator(processDefinition);
        if (this.problemHandler.getProblemCount() > 0) {
            return;
        }
        this.generateJavaMappingConfiguration(processDefinition);
        if (this.problemHandler.getProblemCount() > 0) {
            return;
        }
        try {
            this.callJavaMappingGenerator();
        }
        catch (IOException e) {
            Problem problem = new Problem(2, "java mapping generation failed", (Throwable)e);
            this.problemHandler.add(problem);
            return;
        }
        try {
            this.assembleWebModule(processDefinition);
        }
        catch (IOException e) {
            Problem problem = new Problem(2, "web module assembly failed", (Throwable)e);
            this.problemHandler.add(problem);
            return;
        }
    }

    protected File getWebDirectory() {
        return new File(this.outputDirectory, "web");
    }

    protected File getClassesDirectory() {
        File classesDirectory = new File(this.outputDirectory, DIR_CLASSES);
        classesDirectory.mkdir();
        return classesDirectory;
    }

    protected File getWsdlDirectory() {
        return new File(this.getWebDirectory(), "wsdl");
    }

    protected String getWsdlBindingFile() {
        return this.moduleName + "-binding-.wsdl";
    }

    protected String getWsdlServiceFile() {
        return this.moduleName + "-service.wsdl";
    }

    protected File getJavaMappingConfigurationFile() {
        return new File(this.outputDirectory, "wscompile.xml");
    }

    protected File getJaxRpcMappingFile() {
        return new File(this.getWebDirectory(), "jaxrpc-mapping.xml");
    }

    protected File getWebModuleFile() {
        return new File(this.outputDirectory, this.moduleName + ".war");
    }

    protected void callWsdlServiceGenerator(BpelProcessDefinition processDefinition) {
        WsdlServiceGenerator wsdlServiceGenerator = new WsdlServiceGenerator();
        wsdlServiceGenerator.setOutputDirectory(this.getWsdlDirectory());
        wsdlServiceGenerator.setBindingFile(this.getWsdlBindingFile());
        wsdlServiceGenerator.setServiceFile(this.getWsdlServiceFile());
        wsdlServiceGenerator.setProblemHandler(this.problemHandler);
        wsdlServiceGenerator.generateWsdlService(processDefinition);
    }

    protected void generateJavaMappingConfiguration(BpelProcessDefinition processDefinition) {
        Document wscompileDocument = XmlUtil.createDocument();
        Element configuration = wscompileDocument.createElementNS(NS_WSCOMPILE, ELEM_CONFIGURATION);
        XmlUtil.addNamespaceDeclaration((Element)configuration, (String)NS_WSCOMPILE);
        Element wsdl = wscompileDocument.createElementNS(NS_WSCOMPILE, "wsdl");
        wsdl.setAttribute(ATTR_LOCATION, new File(this.getWsdlDirectory(), this.getWsdlServiceFile()).getAbsolutePath());
        wsdl.setAttribute(ATTR_PACKAGE_NAME, this.generateJavaMappingPackage(processDefinition));
        wscompileDocument.appendChild(configuration);
        configuration.appendChild(wsdl);
        File configFile = this.getJavaMappingConfigurationFile();
        try {
            this.writeFile(wscompileDocument, configFile);
            log.info((Object)("wrote java mapping configuration file: " + configFile));
        }
        catch (IOException e) {
            Problem problem = new Problem(2, "could not write java mapping configuration: " + configFile, (Throwable)e);
            this.problemHandler.add(problem);
        }
        catch (TransformerException e) {
            Problem problem = new Problem(2, "could not transform wscompile configuration to xml text", (Throwable)e);
            this.problemHandler.add(problem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(Document document, File file) throws IOException, TransformerException {
        Transformer xmlWriter = XmlUtil.getTransformerFactory().newTransformer();
        xmlWriter.setErrorListener(this.problemHandler.asTraxErrorListener());
        BufferedOutputStream configSink = new BufferedOutputStream(new FileOutputStream(file));
        try {
            xmlWriter.transform(new DOMSource(document), new StreamResult(configSink));
        }
        finally {
            ((OutputStream)configSink).close();
        }
    }

    protected String generateJavaMappingPackage(BpelProcessDefinition processDefinition) {
        return this.getPackagePrefix() + '.' + this.moduleName;
    }

    private static String toLowerCaseJavaIdentifier(String name) {
        int i;
        int n = name.length();
        char[] identifierBuffer = new char[name.length()];
        for (i = 0; i < n; ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierStart(ch)) continue;
            identifierBuffer[0] = Character.toLowerCase(ch);
            break;
        }
        int k = 1;
        ++i;
        while (i < n) {
            char ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                identifierBuffer[k++] = Character.toLowerCase(ch);
            }
            ++i;
        }
        return new String(identifierBuffer, 0, k);
    }

    protected void callJavaMappingGenerator() throws IOException {
        String[] args = new String[]{"java", "-classpath", wscompileClassPath, "com.sun.xml.rpc.tools.wscompile.Main", "-import", "-features:norpcstructures,wsi", "-d", this.getClassesDirectory().getAbsolutePath(), "-mapping", this.getJaxRpcMappingFile().getAbsolutePath(), "-verbose", this.getJavaMappingConfigurationFile().getAbsolutePath()};
        final Process wscompile = Runtime.getRuntime().exec(args, null, this.getOutputDirectory());
        new Thread(){

            public void run() {
                try {
                    WebModuleGenerator.logOutput(wscompile.getInputStream());
                }
                catch (IOException e) {
                    log.warn((Object)"input pipe from java mapping generator broke", (Throwable)e);
                }
            }
        }.start();
        new Thread(){

            public void run() {
                try {
                    WebModuleGenerator.logError(wscompile.getErrorStream());
                }
                catch (IOException e) {
                    log.warn((Object)"error pipe from java mapping generator broke", (Throwable)e);
                }
            }
        }.start();
        try {
            int exitCode = wscompile.waitFor();
            if (exitCode == 0) {
                log.info((Object)"java mapping generation succeeded");
            } else {
                Problem problem = new Problem(2, "java mapping generation failed: exitCode=" + exitCode);
                this.problemHandler.add(problem);
            }
        }
        catch (InterruptedException e) {
            Problem problem = new Problem(2, "java mapping generation was interrupted");
            this.problemHandler.add(problem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logOutput(InputStream processInput) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(processInput));
        try {
            String line = reader.readLine();
            while (line != null) {
                log.info((Object)line);
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logError(InputStream processError) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(processError));
        try {
            String line = reader.readLine();
            while (line != null) {
                log.error((Object)line);
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assembleWebModule(BpelProcessDefinition processDefinition) throws IOException {
        ZipOutputStream moduleSink = new ZipOutputStream(new FileOutputStream(this.getWebModuleFile()));
        try {
            this.addGeneratedFiles(moduleSink);
            this.addUserProvidedFiles(moduleSink, processDefinition);
        }
        finally {
            moduleSink.close();
        }
    }

    protected void addGeneratedFiles(ZipOutputStream moduleSink) throws IOException {
        FileUtil.addDirectory(this.getWebDirectory(), moduleSink, DIR_WEB_INF);
        FileUtil.addDirectory(this.getClassesDirectory(), moduleSink, "WEB-INF/classes");
    }

    protected void addUserProvidedFiles(ZipOutputStream moduleSink, BpelProcessDefinition processDefinition) throws IOException {
        FileDefinition fileDefinition = processDefinition.getFileDefinition();
        WebModuleGenerator.addFile(fileDefinition, "web.xml", moduleSink, DIR_WEB_INF);
        WebModuleGenerator.addFile(fileDefinition, "webservices.xml", moduleSink, DIR_WEB_INF);
        WebModuleGenerator.addFile(fileDefinition, "bpel-application.xml", moduleSink, "WEB-INF/classes");
    }

    private static void addFile(FileDefinition fileDefinition, String fileName, ZipOutputStream moduleSink, String prefix) throws IOException {
        byte[] fileContent = fileDefinition.getBytes(fileName);
        if (fileContent != null) {
            moduleSink.putNextEntry(new ZipEntry(prefix + '/' + fileName));
            moduleSink.write(fileContent);
            moduleSink.closeEntry();
        }
    }

    private static String getWscompileClassPath() {
        String classPath = System.getProperty(WSCOMPILE_CP_PROPERTY);
        if (classPath == null) {
            throw new IllegalStateException("system property wscompile.class.path not set");
        }
        log.debug((Object)("wscompile raw classpath: " + classPath));
        String[] pathElements = classPath.split(File.pathSeparator);
        StringBuffer pathBuffer = new StringBuffer();
        for (int i = 0; i < pathElements.length; ++i) {
            String pathElement = pathElements[i];
            if (new File(pathElement).exists()) {
                pathBuffer.append(pathElement).append(File.pathSeparatorChar);
                continue;
            }
            log.warn((Object)("wscompile classpath element does not exist: " + pathElement));
        }
        classPath = pathBuffer.toString();
        log.debug((Object)("wscompile classpath: " + classPath));
        return classPath;
    }
}

