/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.ejb.Container;
import org.jboss.ejb.EjbUtil;
import org.jboss.logging.Logger;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDestinationRefMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;
import org.jboss.web.AbstractWebContainer;
import org.jboss.web.WebApplication;
import org.jboss.web.WebPermissionMapping;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.jboss.ws.integration.URLLoaderAdapter;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.omg.CORBA.ORB;

public abstract class AbstractWebDeployer {
    public static final String ERROR = "org.jboss.web.AbstractWebContainer.error";
    protected Logger log = Logger.getLogger(this.getClass());
    protected MBeanServer server;
    protected boolean java2ClassLoadingCompliance = false;
    protected boolean unpackWars = true;
    protected boolean lenientEjbLink = false;
    protected String defaultSecurityDomain;

    public abstract void init(Object var1) throws Exception;

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public boolean getUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean flag) {
        this.unpackWars = flag;
    }

    public boolean getLenientEjbLink() {
        return this.lenientEjbLink;
    }

    public void setLenientEjbLink(boolean flag) {
        this.lenientEjbLink = flag;
    }

    public String getDefaultSecurityDomain() {
        return this.defaultSecurityDomain;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    public synchronized WebApplication start(DeploymentInfo di) throws DeploymentException {
        Thread thread = Thread.currentThread();
        ClassLoader appClassLoader = thread.getContextClassLoader();
        WebApplication warInfo = null;
        try {
            String contextID;
            URL warURL;
            URL[] empty = new URL[]{};
            URLClassLoader warLoader = URLClassLoader.newInstance(empty, (ClassLoader)di.ucl);
            thread.setContextClassLoader(warLoader);
            DescriptorParser webAppParser = new DescriptorParser(di);
            String webContext = di.webContext;
            if (webContext != null && !webContext.startsWith("/")) {
                webContext = "/" + webContext;
            }
            URL uRL = warURL = di.localUrl != null ? di.localUrl : di.url;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("webContext: " + webContext));
                this.log.debug((Object)("warURL: " + warURL));
                this.log.debug((Object)("webAppParser: " + webAppParser));
            }
            WebMetaData webMetaData = (WebMetaData)di.metaData;
            if (di.parent != null && di.parent.metaData instanceof J2eeApplicationMetaData) {
                J2eeApplicationMetaData appMetaData = (J2eeApplicationMetaData)di.parent.metaData;
                if (webMetaData.getSecurityDomain() == null) {
                    webMetaData.setSecurityDomain(appMetaData.getSecurityDomain());
                }
                webMetaData.mergeSecurityRoles(appMetaData.getSecurityRoles());
            }
            if ((contextID = di.shortName) == null) {
                contextID = di.shortName;
            }
            webMetaData.setJaccContextID(contextID);
            PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, true);
            this.createPermissions(webMetaData, pc);
            DeploymentInfo current = di;
            while (current.parent != null) {
                current = current.parent;
            }
            PolicyConfiguration parentPC = (PolicyConfiguration)current.context.get("javax.security.jacc.PolicyConfiguration");
            if (parentPC != null && parentPC != pc) {
                parentPC.linkConfiguration(pc);
            }
            pc.commit();
            Policy.getPolicy().refresh();
            warInfo = new WebApplication(webMetaData);
            warInfo.setDeploymentInfo(di);
            warInfo.setClassLoader(warLoader);
            this.performDeploy(warInfo, warURL.toString(), webAppParser);
        }
        catch (DeploymentException e) {
            di.context.put(ERROR, e);
            throw e;
        }
        catch (Exception e) {
            DeploymentException ex = new DeploymentException("Error during deploy", (Throwable)e);
            di.context.put(ERROR, ex);
            throw ex;
        }
        finally {
            thread.setContextClassLoader(appClassLoader);
        }
        return warInfo;
    }

    protected abstract void performDeploy(WebApplication var1, String var2, AbstractWebContainer.WebDescriptorParser var3) throws Exception;

    public synchronized void stop(DeploymentInfo di) throws DeploymentException {
        URL warURL = di.localUrl != null ? di.localUrl : di.url;
        String warUrl = warURL.toString();
        try {
            WebApplication webApp = (WebApplication)di.context.get("org.jboss.web.AbstractWebContainer.webApp");
            this.performUndeploy(warUrl, webApp);
            WebMetaData webMetaData = (WebMetaData)di.metaData;
            String contextID = webMetaData.getJaccContextID();
            PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, true);
            pc.delete();
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Error during deploy", (Throwable)e);
        }
    }

    protected abstract void performUndeploy(String var1, WebApplication var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseWebAppDescriptors(DeploymentInfo di, ClassLoader loader, WebMetaData metaData) throws Exception {
        this.log.debug((Object)"AbstractWebContainer.parseWebAppDescriptors, Begin");
        InitialContext iniCtx = new InitialContext();
        Context envCtx = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader currentLoader = currentThread.getContextClassLoader();
        try {
            this.log.debug((Object)("Creating ENC using ClassLoader: " + loader));
            for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                this.log.debug((Object)(".." + parent));
            }
            currentThread.setContextClassLoader(loader);
            metaData.setENCLoader(loader);
            envCtx = (Context)iniCtx.lookup("java:comp");
            ORB orb = null;
            try {
                orb = (ORB)this.server.getAttribute(Container.ORB_NAME, "ORB");
            }
            catch (Throwable t) {
                this.log.debug((Object)("Unable to retrieve orb" + t.toString()));
            }
            if (orb != null) {
                NonSerializableFactory.rebind((Context)envCtx, (String)"ORB", (Object)orb);
                this.log.debug((Object)"Bound java:comp/ORB");
            }
            envCtx.bind("UserTransaction", (Object)new LinkRef("UserTransaction"));
            this.log.debug((Object)"Linked java:comp/UserTransaction to JNDI name: UserTransaction");
            envCtx = envCtx.createSubcontext("env");
        }
        finally {
            currentThread.setContextClassLoader(currentLoader);
        }
        Iterator envEntries = metaData.getEnvironmentEntries();
        this.log.debug((Object)"addEnvEntries");
        this.addEnvEntries(envEntries, envCtx);
        Iterator resourceEnvRefs = metaData.getResourceEnvReferences();
        this.log.debug((Object)"linkResourceEnvRefs");
        this.linkResourceEnvRefs(resourceEnvRefs, envCtx);
        Iterator resourceRefs = metaData.getResourceReferences();
        this.log.debug((Object)"linkResourceRefs");
        this.linkResourceRefs(resourceRefs, envCtx);
        this.log.debug((Object)"linkMessageDestinationRefs");
        this.linkMessageDestinationRefs(metaData, envCtx, di);
        Iterator ejbRefs = metaData.getEjbReferences();
        this.log.debug((Object)"linkEjbRefs");
        this.linkEjbRefs(ejbRefs, envCtx, di);
        Iterator ejbLocalRefs = metaData.getEjbLocalReferences();
        this.log.debug((Object)"linkEjbLocalRefs");
        this.linkEjbLocalRefs(ejbLocalRefs, envCtx, di);
        this.log.debug((Object)"linkServiceRefs");
        this.linkServiceRefs(metaData, envCtx, di);
        String securityDomain = metaData.getSecurityDomain();
        this.log.debug((Object)"linkSecurityDomain");
        this.linkSecurityDomain(securityDomain, envCtx);
        this.log.debug((Object)"AbstractWebContainer.parseWebAppDescriptors, End");
    }

    private void linkServiceRefs(WebMetaData metaData, Context envCtx, DeploymentInfo di) throws NamingException {
        URLLoaderAdapter vfsRoot = new URLLoaderAdapter(di.url);
        for (ServiceRefMetaData sref : metaData.getServiceReferences().values()) {
            String refName = sref.getServiceRefName();
            new ServiceRefDelegate().bindServiceRef(envCtx, refName, (UnifiedVirtualFile)vfsRoot, (ClassLoader)di.ucl, sref);
        }
    }

    protected void addEnvEntries(Iterator envEntries, Context envCtx) throws ClassNotFoundException, NamingException {
        while (envEntries.hasNext()) {
            EnvEntryMetaData entry = (EnvEntryMetaData)envEntries.next();
            this.log.debug((Object)("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue()));
            EnvEntryMetaData.bindEnvEntry(envCtx, entry);
        }
    }

    protected void linkResourceEnvRefs(Iterator resourceEnvRefs, Context envCtx) throws NamingException {
        while (resourceEnvRefs.hasNext()) {
            ResourceEnvRefMetaData ref = (ResourceEnvRefMetaData)resourceEnvRefs.next();
            String resourceName = ref.getJndiName();
            String refName = ref.getRefName();
            if (ref.getType().equals("java.net.URL")) {
                try {
                    this.log.debug((Object)("Binding '" + refName + "' to URL: " + resourceName));
                    URL url = new URL(resourceName);
                    Util.bind((Context)envCtx, (String)refName, (Object)url);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new NamingException("Malformed URL:" + e.getMessage());
                }
            }
            if (resourceName != null) {
                this.log.debug((Object)("Linking '" + refName + "' to JNDI name: " + resourceName));
                Util.bind((Context)envCtx, (String)refName, (Object)new LinkRef(resourceName));
                continue;
            }
            throw new NamingException("resource-env-ref: " + refName + " has no valid JNDI binding. Check the jboss-web/resource-env-ref.");
        }
    }

    protected void linkResourceRefs(Iterator resourceRefs, Context envCtx) throws NamingException {
        while (resourceRefs.hasNext()) {
            ResourceRefMetaData ref = (ResourceRefMetaData)resourceRefs.next();
            String jndiName = ref.getJndiName();
            String refName = ref.getRefName();
            if (ref.getType().equals("java.net.URL")) {
                try {
                    String resURL = ref.getResURL();
                    if (ref.getResURL() != null) {
                        this.log.debug((Object)("Binding '" + refName + "' to URL: " + resURL));
                        URL url = new URL(resURL);
                        Util.bind((Context)envCtx, (String)refName, (Object)url);
                        continue;
                    }
                    this.log.debug((Object)("Linking '" + refName + "' to URL: " + resURL));
                    LinkRef urlLink = new LinkRef(jndiName);
                    Util.bind((Context)envCtx, (String)refName, (Object)urlLink);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new NamingException("Malformed URL:" + e.getMessage());
                }
            }
            if (jndiName != null) {
                this.log.debug((Object)("Linking '" + refName + "' to JNDI name: " + jndiName));
                Util.bind((Context)envCtx, (String)refName, (Object)new LinkRef(jndiName));
                continue;
            }
            throw new NamingException("resource-ref: " + refName + " has no valid JNDI binding. Check the jboss-web/resource-ref.");
        }
    }

    protected void linkMessageDestinationRefs(WebMetaData metaData, Context envCtx, DeploymentInfo di) throws NamingException, DeploymentException {
        Iterator i = metaData.getMessageDestinationReferences();
        while (i.hasNext()) {
            MessageDestinationRefMetaData ref = (MessageDestinationRefMetaData)i.next();
            String refName = ref.getRefName();
            String jndiName = ref.getJNDIName();
            String link = ref.getLink();
            if (link != null) {
                if (jndiName == null) {
                    MessageDestinationMetaData messageDestination = EjbUtil.findMessageDestination(this.server, di, link);
                    if (messageDestination == null) {
                        throw new DeploymentException("message-destination-ref '" + refName + "' message-destination-link '" + link + "' not found and no jndi-name in jboss-web.xml");
                    }
                    String linkJNDIName = messageDestination.getJNDIName();
                    if (linkJNDIName == null) {
                        this.log.warn((Object)("message-destination '" + link + "' has no jndi-name in jboss-web.xml"));
                    } else {
                        jndiName = linkJNDIName;
                    }
                } else {
                    this.log.warn((Object)("message-destination-ref '" + refName + "' ignoring message-destination-link '" + link + "' because it has a jndi-name in jboss-web.xml"));
                }
            } else if (jndiName == null) {
                throw new DeploymentException("message-destination-ref '" + refName + "' has no message-destination-link in web.xml and no jndi-name in jboss-web.xml");
            }
            Util.bind((Context)envCtx, (String)refName, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkEjbRefs(Iterator ejbRefs, Context envCtx, DeploymentInfo di) throws NamingException {
        while (ejbRefs.hasNext()) {
            EjbRefMetaData ejb = (EjbRefMetaData)ejbRefs.next();
            String name = ejb.getName();
            String linkName = ejb.getLink();
            String jndiName = null;
            if (linkName != null && (jndiName = EjbUtil.findEjbLink(this.server, di, linkName)) == null && !this.getLenientEjbLink()) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link match");
            }
            if (jndiName == null && (jndiName = ejb.getJndiName()) == null) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link in web.xml and no jndi-name in jboss-web.xml");
            }
            this.log.debug((Object)("Linking ejb-ref: " + name + " to JNDI name: " + jndiName));
            Util.bind((Context)envCtx, (String)name, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkEjbLocalRefs(Iterator ejbRefs, Context envCtx, DeploymentInfo di) throws NamingException {
        while (ejbRefs.hasNext()) {
            EjbLocalRefMetaData ejb = (EjbLocalRefMetaData)ejbRefs.next();
            String name = ejb.getName();
            String linkName = ejb.getLink();
            String jndiName = null;
            if (linkName != null && (jndiName = EjbUtil.findLocalEjbLink(this.server, di, linkName)) == null && !this.getLenientEjbLink()) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link match");
            }
            if (jndiName == null && (jndiName = ejb.getJndiName()) == null) {
                String msg = null;
                msg = linkName == null ? "ejb-local-ref: '" + name + "', no ejb-link in web.xml and " + "no local-jndi-name in jboss-web.xml" : "ejb-local-ref: '" + name + "', with web.xml ejb-link: '" + linkName + "' failed to resolve to an ejb with a LocalHome";
                throw new NamingException(msg);
            }
            this.log.debug((Object)("Linking ejb-local-ref: " + name + " to JNDI name: " + jndiName));
            Util.bind((Context)envCtx, (String)name, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkSecurityDomain(String securityDomain, Context envCtx) throws NamingException {
        if (securityDomain == null) {
            securityDomain = this.getDefaultSecurityDomain();
            this.log.debug((Object)("No security-domain given, using default: " + securityDomain));
        }
        this.log.debug((Object)("Linking security/securityMgr to JNDI name: " + securityDomain));
        Util.bind((Context)envCtx, (String)"security/securityMgr", (Object)new LinkRef(securityDomain));
        Util.bind((Context)envCtx, (String)"security/realmMapping", (Object)new LinkRef(securityDomain));
        Util.bind((Context)envCtx, (String)"security/security-domain", (Object)new LinkRef(securityDomain));
        Util.bind((Context)envCtx, (String)"security/subject", (Object)new LinkRef(securityDomain + "/subject"));
    }

    public String[] getStandardCompileClasspath(ClassLoader loader) {
        String[] jspResources = new String[]{"javax/servlet/resources/web-app_2_3.dtd", "org/apache/jasper/resources/jsp12.dtd", "javax/ejb/EJBHome.class"};
        ArrayList<String> tmp = new ArrayList<String>();
        for (int j = 0; j < jspResources.length; ++j) {
            URL rsrcURL = loader.getResource(jspResources[j]);
            if (rsrcURL != null) {
                String url = rsrcURL.toExternalForm();
                if (rsrcURL.getProtocol().equals("jar")) {
                    url = url.substring(4);
                    int seperator = url.indexOf(33);
                    url = url.substring(0, seperator);
                }
                tmp.add(url);
                continue;
            }
            this.log.warn((Object)("Failed to fin jsp rsrc: " + jspResources[j]));
        }
        this.log.trace((Object)("JSP StandardCompileClasspath: " + tmp));
        String[] cp = new String[tmp.size()];
        tmp.toArray(cp);
        return cp;
    }

    public String[] getCompileClasspath(ClassLoader loader) {
        HashSet tmp = new HashSet();
        for (ClassLoader cl = loader; cl != null; cl = cl.getParent()) {
            URL[] urls = AbstractWebContainer.getClassLoaderURLs(cl);
            this.addURLs(tmp, urls);
        }
        try {
            URL[] globalUrls = (URL[])this.server.getAttribute(LoaderRepositoryFactory.DEFAULT_LOADER_REPOSITORY, "URLs");
            this.addURLs(tmp, globalUrls);
        }
        catch (Exception e) {
            this.log.warn((Object)"Could not get global URL[] from default loader repository!", (Throwable)e);
        }
        this.log.trace((Object)("JSP CompileClasspath: " + tmp));
        String[] cp = new String[tmp.size()];
        tmp.toArray(cp);
        return cp;
    }

    private void addURLs(Set urlSet, URL[] urls) {
        for (int u = 0; u < urls.length; ++u) {
            URL url = urls[u];
            urlSet.add(url.toExternalForm());
        }
    }

    protected void createPermissions(WebMetaData metaData, PolicyConfiguration pc) throws PolicyContextException {
        WebPermissionMapping.createPermissions(metaData, pc);
    }

    private class DescriptorParser
    implements AbstractWebContainer.WebDescriptorParser {
        DeploymentInfo di;

        DescriptorParser(DeploymentInfo di) {
            this.di = di;
        }

        public void parseWebAppDescriptors(ClassLoader loader, WebMetaData metaData) throws Exception {
            AbstractWebDeployer.this.parseWebAppDescriptors(this.di, loader, metaData);
        }

        public DeploymentInfo getDeploymentInfo() {
            return this.di;
        }
    }
}

