/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.util.file.FilenameSuffixFilter;
import org.jboss.util.file.JarUtils;
import org.jboss.web.AbstractWebContainerMBean;
import org.jboss.web.AbstractWebDeployer;
import org.jboss.web.WebApplication;
import org.jboss.web.WebModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractWebContainer
extends SubDeployerSupport
implements AbstractWebContainerMBean {
    public static final String DEPLOYER = "org.jboss.web.AbstractWebContainer.deployer";
    public static final String WEB_APP = "org.jboss.web.AbstractWebContainer.webApp";
    public static final String WEB_MODULE = "org.jboss.web.AbstractWebContainer.webModule";
    public static final String ERROR = "org.jboss.web.AbstractWebContainer.error";
    private static final String[] DEFAULT_ENHANCED_SUFFIXES = new String[]{"500:.war"};
    protected HashMap deploymentMap = new HashMap();
    protected boolean java2ClassLoadingCompliance = false;
    protected boolean unpackWars = true;
    protected boolean acceptNonWarDirs = false;
    protected boolean lenientEjbLink = false;
    protected String defaultSecurityDomain = "java:/jaas/other";
    private String subjectAttributeName = null;
    protected ServiceControllerMBean serviceController;

    public AbstractWebContainer() {
        this.setEnhancedSuffixes(DEFAULT_ENHANCED_SUFFIXES);
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public boolean getUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean flag) {
        this.unpackWars = flag;
    }

    public boolean getAcceptNonWarDirs() {
        return this.acceptNonWarDirs;
    }

    public void setAcceptNonWarDirs(boolean flag) {
        this.acceptNonWarDirs = flag;
    }

    public boolean getLenientEjbLink() {
        return this.lenientEjbLink;
    }

    public void setLenientEjbLink(boolean flag) {
        this.lenientEjbLink = flag;
    }

    public String getDefaultSecurityDomain() {
        return this.defaultSecurityDomain;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    public String getSubjectAttributeName() {
        return this.subjectAttributeName;
    }

    public void setSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeName = subjectAttributeName;
    }

    public abstract AbstractWebDeployer getDeployer(DeploymentInfo var1) throws Exception;

    public boolean accepts(DeploymentInfo sdi) {
        boolean accepts = super.accepts(sdi);
        if (!accepts && this.acceptNonWarDirs && sdi.url.getProtocol().equalsIgnoreCase("file")) {
            File webXml = new File(sdi.url.getFile(), "WEB-INF/web.xml");
            accepts = webXml.exists();
        }
        return accepts;
    }

    public synchronized void init(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)"Begin init");
        this.server = di.getServer();
        try {
            di.watch = di.url.getPath().endsWith("/") ? new URL(di.url, "WEB-INF/web.xml") : di.url;
            boolean unpackWebservice = di.localCl.findResource("WEB-INF/webservices.xml") != null;
            File warFile = new File(di.localUrl.getFile());
            if (!warFile.isDirectory() && (this.unpackWars || (unpackWebservice |= this.server.isRegistered(ObjectNameFactory.create((String)"jboss.ws:service=ServiceEndpointManager"))))) {
                String prefix = warFile.getCanonicalPath();
                File expWarFile = new File((prefix = prefix.substring(0, prefix.lastIndexOf(".war"))) + "-exp.war");
                if (!expWarFile.mkdir()) {
                    throw new DeploymentException("Was unable to mkdir: " + expWarFile);
                }
                this.log.debug((Object)("Unpacking war to: " + expWarFile));
                FileInputStream fis = new FileInputStream(warFile);
                JarUtils.unjar((InputStream)fis, (File)expWarFile);
                fis.close();
                this.log.debug((Object)"Replaced war with unpacked contents");
                if (!warFile.delete()) {
                    this.log.debug((Object)"Was unable to delete war file");
                } else {
                    this.log.debug((Object)"Deleted war archive");
                }
                di.localUrl = expWarFile.toURL();
                URL[] localCl = new URL[]{di.localUrl};
                di.localCl = new URLClassLoader(localCl);
            }
            WebMetaData metaData = new WebMetaData();
            metaData.setResourceClassLoader(di.localCl);
            metaData.setJava2ClassLoadingCompliance(this.java2ClassLoadingCompliance);
            di.metaData = metaData;
            String webContext = di.webContext;
            if (webContext != null && webContext.length() > 0 && webContext.charAt(0) != '/') {
                webContext = "/" + webContext;
            }
            URL warURL = di.localUrl != null ? di.localUrl : di.url;
            this.log.debug((Object)("webContext: " + webContext));
            this.log.debug((Object)("warURL: " + warURL));
            this.parseMetaData(webContext, warURL, di.shortName, metaData);
            LoaderRepositoryFactory.LoaderRepositoryConfig config = metaData.getLoaderConfig();
            if (config != null) {
                di.setRepositoryInfo(config);
            }
            super.init(di);
        }
        catch (DeploymentException e) {
            this.log.debug((Object)"Problem in init ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Problem in init ", (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        this.log.debug((Object)"End init");
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("create, " + di.shortName));
        try {
            ArrayList<URL> urlList;
            URL loaderURL = di.localUrl != null ? di.localUrl : di.url;
            File warFile = new File(di.localUrl.getFile());
            if (warFile.isDirectory()) {
                urlList = new ArrayList<URL>();
                urlList.add(new URL(loaderURL + "WEB-INF/classes/"));
                File libDir = new File(warFile, "WEB-INF/lib/");
                String[] jarArr = libDir.list((FilenameFilter)new FilenameSuffixFilter(".jar"));
                for (int i = 0; jarArr != null && i < jarArr.length; ++i) {
                    String urlStr = loaderURL + "WEB-INF/lib/" + jarArr[i];
                    urlList.add(new URL(urlStr));
                }
                URL[] urlArr = new URL[urlList.size()];
                urlList.toArray(urlArr);
                di.annotationsCl = new URLClassLoader(urlArr, (ClassLoader)di.ucl);
            } else {
                urlList = new ArrayList();
                urlList.add(new URL(warFile + "!WEB-INF/classes"));
                FileInputStream fis = new FileInputStream(warFile);
                JarInputStream jin = new JarInputStream(fis);
                ZipEntry entry = jin.getNextEntry();
                while (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.startsWith("WEB-INF/lib")) {
                        urlList.add(new URL(warFile + "!" + entryName));
                    }
                    entry = jin.getNextEntry();
                }
                jin.close();
                URL[] urlArr = new URL[urlList.size()];
                urlList.toArray(urlArr);
                di.annotationsCl = new URLClassLoader(urlArr, (ClassLoader)di.ucl);
            }
            AbstractWebDeployer deployer = this.getDeployer(di);
            di.context.put(DEPLOYER, deployer);
            WebMetaData metaData = (WebMetaData)di.metaData;
            Collection depends = metaData.getDepends();
            WebModule module = new WebModule(di, this, deployer);
            ObjectName jmxName = new ObjectName("jboss.web.deployment:war=" + di.shortName + ",id=" + di.hashCode());
            this.server.registerMBean(module, jmxName);
            di.context.put(WEB_MODULE, jmxName);
            this.serviceController.create(jmxName, depends);
            super.create(di);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to create web module", (Throwable)e);
        }
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        ObjectName jmxName = (ObjectName)di.context.get(WEB_MODULE);
        try {
            this.serviceController.start(jmxName);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to start web module", (Throwable)e);
        }
        DeploymentException e = (DeploymentException)((Object)di.context.get(ERROR));
        if (e != null) {
            throw e;
        }
        super.start(di);
    }

    public synchronized void stop(DeploymentInfo di) throws DeploymentException {
        ObjectName jmxName = (ObjectName)di.context.get(WEB_MODULE);
        try {
            if (jmxName != null) {
                this.serviceController.stop(jmxName);
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to stop web module", (Throwable)e);
        }
        super.stop(di);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(DeploymentInfo di) throws DeploymentException {
        block6: {
            ObjectName jmxName = (ObjectName)di.context.get(WEB_MODULE);
            try {
                if (jmxName == null) break block6;
                try {
                    this.serviceController.destroy(jmxName);
                }
                finally {
                    this.serviceController.remove(jmxName);
                }
            }
            catch (DeploymentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to stop web module", (Throwable)e);
            }
        }
        super.destroy(di);
    }

    public boolean isDeployed(String warUrl) {
        return this.deploymentMap.containsKey(warUrl);
    }

    public void addDeployedApp(URL warURL, WebApplication webApp) {
        this.deploymentMap.put(warURL, webApp);
    }

    public WebApplication getDeployedApp(String warUrl) {
        WebApplication appInfo = (WebApplication)this.deploymentMap.get(warUrl);
        return appInfo;
    }

    public WebApplication removeDeployedApp(URL warURL) {
        WebApplication appInfo = (WebApplication)this.deploymentMap.remove(warURL);
        return appInfo;
    }

    public Iterator getDeployedApplications() {
        return this.deploymentMap.values().iterator();
    }

    public Element getConfig() {
        return null;
    }

    public void setConfig(Element config) {
    }

    public static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Object[] args;
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
            if ((urls == null || urls.length == 0) && returnType.isAssignableFrom((getURLs = cl.getClass().getMethod("getAllURLs", parameterTypes)).getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    public String[] getCompileClasspath(ClassLoader loader) {
        HashSet tmp = new HashSet();
        for (ClassLoader cl = loader; cl != null; cl = cl.getParent()) {
            URL[] urls = AbstractWebContainer.getClassLoaderURLs(cl);
            this.addURLs(tmp, urls);
        }
        try {
            URL[] globalUrls = (URL[])this.server.getAttribute(LoaderRepositoryFactory.DEFAULT_LOADER_REPOSITORY, "URLs");
            this.addURLs(tmp, globalUrls);
        }
        catch (Exception e) {
            this.log.warn((Object)"Could not get global URL[] from default loader repository!");
        }
        this.log.trace((Object)("JSP CompileClasspath: " + tmp));
        String[] cp = new String[tmp.size()];
        tmp.toArray(cp);
        return cp;
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        super.startService();
    }

    protected void parseMetaData(String ctxPath, URL warURL, String warName, WebMetaData metaData) throws DeploymentException {
        InputStream jbossWebIS = null;
        InputStream webIS = null;
        try {
            File warDir = new File(warURL.getFile());
            if (warURL.getProtocol().equals("file") && warDir.isDirectory()) {
                File jbossWebDD;
                File webDD = new File(warDir, "WEB-INF/web.xml");
                if (webDD.exists()) {
                    webIS = new FileInputStream(webDD);
                }
                if ((jbossWebDD = new File(warDir, "WEB-INF/jboss-web.xml")).exists()) {
                    jbossWebIS = new FileInputStream(jbossWebDD);
                }
            } else {
                ZipEntry entry;
                InputStream warIS = warURL.openStream();
                ZipInputStream zipIS = new ZipInputStream(warIS);
                byte[] buffer = new byte[512];
                while ((entry = zipIS.getNextEntry()) != null) {
                    int bytes;
                    ByteArrayOutputStream baos;
                    if (entry.getName().equals("WEB-INF/web.xml")) {
                        baos = new ByteArrayOutputStream();
                        while ((bytes = zipIS.read(buffer)) > 0) {
                            baos.write(buffer, 0, bytes);
                        }
                        webIS = new ByteArrayInputStream(baos.toByteArray());
                        continue;
                    }
                    if (!entry.getName().equals("WEB-INF/jboss-web.xml")) continue;
                    baos = new ByteArrayOutputStream();
                    while ((bytes = zipIS.read(buffer)) > 0) {
                        baos.write(buffer, 0, bytes);
                    }
                    jbossWebIS = new ByteArrayInputStream(baos.toByteArray());
                }
                zipIS.close();
            }
            XmlFileLoader xmlLoader = new XmlFileLoader();
            String warURI = warURL.toExternalForm();
            try {
                if (webIS != null) {
                    Document webDoc = xmlLoader.getDocument(webIS, warURI + "/WEB-INF/web.xml");
                    Element web = webDoc.getDocumentElement();
                    metaData.importXml(web);
                }
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to parse WEB-INF/web.xml", (Throwable)e);
            }
            try {
                if (jbossWebIS != null) {
                    Document jbossWebDoc = xmlLoader.getDocument(jbossWebIS, warURI + "/WEB-INF/jboss-web.xml");
                    Element jbossWeb = jbossWebDoc.getDocumentElement();
                    metaData.importXml(jbossWeb);
                }
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to parse WEB-INF/jboss-web.xml", (Throwable)e);
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to parse descriptors for war(" + warURL + ")"), (Throwable)e);
        }
        String webContext = ctxPath;
        if (webContext == null) {
            webContext = metaData.getContextRoot();
        }
        if (webContext == null) {
            char c;
            int index;
            int suffix;
            int prefix;
            webContext = warName;
            if ((webContext = webContext.replace('\\', '/')).endsWith("/")) {
                webContext = webContext.substring(0, webContext.length() - 1);
            }
            if ((prefix = webContext.lastIndexOf(47)) > 0) {
                webContext = webContext.substring(prefix + 1);
            }
            if ((suffix = webContext.lastIndexOf(".war")) > 0) {
                webContext = webContext.substring(0, suffix);
            }
            for (index = 0; index < webContext.length() && (Character.isDigit(c = webContext.charAt(index)) || c == '.'); ++index) {
            }
            webContext = webContext.substring(index);
        }
        if (webContext.length() > 0 && webContext.charAt(0) != '/') {
            webContext = "/" + webContext;
        } else if (webContext.equals("/")) {
            webContext = "";
        }
        metaData.setContextRoot(webContext);
    }

    private void addURLs(Set urlSet, URL[] urls) {
        for (int u = 0; u < urls.length; ++u) {
            URL url = urls[u];
            urlSet.add(url.toExternalForm());
        }
    }

    public static interface WebDescriptorParser {
        public void parseWebAppDescriptors(ClassLoader var1, WebMetaData var2) throws Exception;

        public DeploymentInfo getDeploymentInfo();
    }
}

