/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.net.URL;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.w3c.dom.Element;

public final class JDBCXmlFileLoader {
    private final ApplicationMetaData application;
    private final ClassLoader classLoader;
    private final ClassLoader localClassLoader;
    private final Logger log;

    public JDBCXmlFileLoader(ApplicationMetaData application, ClassLoader classLoader, ClassLoader localClassLoader, Logger log) {
        this.application = application;
        this.classLoader = classLoader;
        this.localClassLoader = localClassLoader;
        this.log = log;
    }

    public JDBCApplicationMetaData load() throws DeploymentException {
        JDBCApplicationMetaData jamd = new JDBCApplicationMetaData(this.application, this.classLoader);
        URL stdJDBCUrl = this.classLoader.getResource("standardjbosscmp-jdbc.xml");
        if (stdJDBCUrl == null) {
            throw new DeploymentException("No standardjbosscmp-jdbc.xml found");
        }
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("Loading standardjbosscmp-jdbc.xml : " + stdJDBCUrl.toString()));
        }
        Element stdJDBCElement = XmlFileLoader.getDocument(stdJDBCUrl, true).getDocumentElement();
        jamd = new JDBCApplicationMetaData(stdJDBCElement, jamd);
        URL jdbcUrl = this.localClassLoader.getResource("META-INF/jbosscmp-jdbc.xml");
        if (jdbcUrl != null) {
            if (debug) {
                this.log.debug((Object)(jdbcUrl.toString() + " found. Overriding defaults"));
            }
            Element jdbcElement = XmlFileLoader.getDocument(jdbcUrl, true).getDocumentElement();
            jamd = new JDBCApplicationMetaData(jdbcElement, jamd);
        }
        return jamd;
    }
}

