/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.blocks.Xid;

public class ReplicationData
implements Externalizable {
    public static final int SEND = 1;
    public static final int COMMIT = 2;
    public static final int ROLLBACK = 3;
    int type = 0;
    byte[] data = null;
    Xid transaction = null;
    byte[] lock_info = null;
    long lock_acquisition_timeout = 0L;
    long lock_lease_timeout = 0L;
    boolean use_locks = false;

    public ReplicationData() {
    }

    public ReplicationData(int type, byte[] data, Xid transaction, byte[] lock_info, long lock_acquisition_timeout, long lock_lease_timeout, boolean use_locks) {
        this.type = type;
        this.data = data;
        this.transaction = transaction;
        this.lock_info = lock_info;
        this.lock_acquisition_timeout = lock_acquisition_timeout;
        this.lock_lease_timeout = lock_lease_timeout;
        this.use_locks = use_locks;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public Xid getTransaction() {
        return this.transaction;
    }

    public byte[] getLockInfo() {
        return this.lock_info;
    }

    public long getLockAcquisitionTimeout() {
        return this.lock_acquisition_timeout;
    }

    public long getLockLeaseTimeout() {
        return this.lock_lease_timeout;
    }

    public boolean useLocks() {
        return this.use_locks;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ReplicationData.typeToString(this.type)).append(" [").append(", transaction=").append(this.transaction);
        switch (this.type) {
            case 1: {
                if (this.data != null) {
                    sb.append(", data=").append(this.data.length).append(" bytes");
                }
                sb.append(", lock_acquisition_timeout=").append(this.lock_acquisition_timeout);
                sb.append(", lock_lease_timeout=").append(this.lock_lease_timeout);
                sb.append(", use_locks=").append(this.use_locks);
                break;
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public static String typeToString(int t) {
        switch (t) {
            case 1: {
                return "SEND";
            }
            case 2: {
                return "COMMIT";
            }
            case 3: {
                return "ROLLBACK";
            }
        }
        return "<unknown>";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        if (this.data != null) {
            out.writeInt(this.data.length);
            out.write(this.data, 0, this.data.length);
        } else {
            out.writeInt(0);
        }
        if (this.transaction != null) {
            out.writeBoolean(true);
            this.transaction.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.use_locks) {
            out.writeBoolean(true);
            if (this.lock_info != null) {
                out.writeInt(this.lock_info.length);
                out.write(this.lock_info, 0, this.lock_info.length);
            } else {
                out.writeInt(0);
            }
            out.writeLong(this.lock_acquisition_timeout);
            out.writeLong(this.lock_lease_timeout);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        int num = in.readInt();
        if (num > 0) {
            this.data = new byte[num];
            in.readFully(this.data, 0, num);
        }
        if (in.readBoolean()) {
            this.transaction = new Xid();
            this.transaction.readExternal(in);
        }
        this.use_locks = in.readBoolean();
        if (this.use_locks) {
            num = in.readInt();
            if (num > 0) {
                this.lock_info = new byte[num];
                in.readFully(this.lock_info, 0, num);
            }
            this.lock_acquisition_timeout = in.readLong();
            this.lock_lease_timeout = in.readLong();
        }
    }
}

