/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rules.InvalidRuleSessionException;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.StatelessRuleSession;
import org.drools.ObjectFilter;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.jsr94.rules.AbstractRuleSessionImpl;
import org.drools.jsr94.rules.IteratorToList;
import org.drools.jsr94.rules.ObjectFilterAdapter;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetRepository;

public class StatelessRuleSessionImpl
extends AbstractRuleSessionImpl
implements StatelessRuleSession {
    StatelessRuleSessionImpl(String bindUri, Map properties, RuleExecutionSetRepository repository) throws RuleExecutionSetNotFoundException {
        super(repository);
        this.setProperties(properties);
        RuleExecutionSetImpl ruleSet = (RuleExecutionSetImpl)repository.getRuleExecutionSet(bindUri);
        if (ruleSet == null) {
            throw new RuleExecutionSetNotFoundException("RuleExecutionSet unbound: " + bindUri);
        }
        this.setRuleExecutionSet(ruleSet);
    }

    protected StatelessSession newStatelessSession() {
        StatelessSession session = this.getRuleExecutionSet().newStatelessSession();
        Map props = this.getProperties();
        if (props != null) {
            Iterator iterator = props.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                session.setGlobal((String)entry.getKey(), entry.getValue());
            }
        }
        return session;
    }

    public List executeRules(List objects) throws InvalidRuleSessionException {
        return this.executeRules(objects, this.getRuleExecutionSet().getObjectFilter());
    }

    public List executeRules(List objects, javax.rules.ObjectFilter filter) throws InvalidRuleSessionException {
        StatelessSession session = this.newStatelessSession();
        StatelessSessionResult results = session.executeWithResults((Collection)objects);
        return IteratorToList.convert(results.iterateObjects((ObjectFilter)new ObjectFilterAdapter(filter)));
    }

    public int getType() throws InvalidRuleSessionException {
        return 1;
    }

    protected void checkRuleSessionValidity() throws InvalidRuleSessionException {
        if (this.getRuleExecutionSet() == null) {
            throw new InvalidRuleSessionException("invalid rule session");
        }
    }
}

