/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.decisiontable.model.SnippetBuilder;
import org.drools.decisiontable.parser.SourceBuilder;

public class LhsBuilder
implements SourceBuilder {
    private String column;
    private Map constraints;
    private List values;
    private boolean hasValues;
    private static Set operators = new HashSet();

    public LhsBuilder(String colDefinition) {
        this.column = colDefinition == null ? "" : colDefinition;
        this.constraints = new HashMap();
        this.values = new ArrayList();
    }

    public void addTemplate(int column, String content) {
        Integer key = new Integer(column);
        content = content.trim();
        if (this.constraints.containsKey(key)) {
            throw new IllegalArgumentException("Internal error: Can't have a constraint added twice to one spreadsheet col.");
        }
        FieldType fieldType = this.calcFieldType(content);
        if (fieldType == FieldType.NORMAL_FIELD || !this.isMultipleConstraints()) {
            this.constraints.put(key, content);
        } else if (fieldType == FieldType.SINGLE_FIELD) {
            this.constraints.put(key, content + " == \"$param\"");
        } else if (fieldType == FieldType.OPERATOR_FIELD) {
            this.constraints.put(key, content + " \"$param\"");
        }
    }

    public void clearValues() {
        this.hasValues = false;
        this.values.clear();
    }

    public void addCellValue(int col, String value) {
        this.hasValues = true;
        Integer key = new Integer(col);
        String content = (String)this.constraints.get(key);
        SnippetBuilder snip = new SnippetBuilder(content);
        String result = snip.build(value);
        this.values.add(result);
    }

    public String getResult() {
        StringBuffer buf = new StringBuffer();
        if (!this.isMultipleConstraints()) {
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                String content = (String)iter.next();
                buf.append(content);
                if (!iter.hasNext()) continue;
                buf.append('\n');
            }
            return buf.toString();
        }
        buf.append(this.column);
        buf.append('(');
        Iterator iter = this.values.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    boolean isMultipleConstraints() {
        if ("".equals(this.column)) {
            return false;
        }
        return !this.column.endsWith(")");
    }

    public FieldType calcFieldType(String content) {
        if (content.indexOf("$param") != -1 || content.indexOf("$1") != -1) {
            return FieldType.NORMAL_FIELD;
        }
        Iterator iter = operators.iterator();
        while (iter.hasNext()) {
            String op = (String)iter.next();
            if (!content.endsWith(op)) continue;
            return FieldType.OPERATOR_FIELD;
        }
        return FieldType.SINGLE_FIELD;
    }

    public boolean hasValues() {
        return this.hasValues;
    }

    static {
        operators.add("==");
        operators.add("=");
        operators.add("!=");
        operators.add("<");
        operators.add(">");
        operators.add("<=");
        operators.add(">=");
        operators.add("contains");
        operators.add("matches");
    }

    static class FieldType {
        public static final FieldType SINGLE_FIELD = new FieldType();
        public static final FieldType OPERATOR_FIELD = new FieldType();
        public static final FieldType NORMAL_FIELD = new FieldType();

        FieldType() {
        }
    }
}

