/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.model.Condition;
import org.drools.decisiontable.model.Rule;
import org.drools.decisiontable.model.SnippetBuilder;
import org.drools.decisiontable.parser.Column;
import org.drools.decisiontable.parser.TemplateColumn;
import org.drools.decisiontable.parser.TemplateContainer;
import org.drools.util.StringUtils;

class DefaultTemplateColumn
implements TemplateColumn {
    private static final Pattern COLUMN_PATTERN = Pattern.compile("^(!?)([a-zA-Z0-9_]*)(\\[([0-9]+)\\])?\\s*(.*)");
    private boolean notCondition;
    private String columnName;
    private String condition;
    private TemplateContainer templateContainer;
    private int index = -1;

    DefaultTemplateColumn(TemplateContainer tc, String columnString) {
        this.templateContainer = tc;
        Matcher matcher = COLUMN_PATTERN.matcher(columnString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("column " + columnString + " is not valid");
        }
        this.notCondition = !StringUtils.isEmpty((String)matcher.group(1));
        this.columnName = matcher.group(2);
        String indexString = matcher.group(4);
        this.condition = matcher.group(5);
        if (!StringUtils.isEmpty((String)indexString)) {
            this.index = Integer.parseInt(indexString);
        }
    }

    private void createCellCondition(Rule rule) {
        StringBuffer conditionString = new StringBuffer();
        Column column = this.templateContainer.getColumn(this.columnName);
        column.getCondition(this.condition, this.index);
        if (this.notCondition) {
            conditionString.append("not ");
        }
        conditionString.append("exists ");
        conditionString.append(column.getCondition(this.condition, this.index));
        SnippetBuilder snip = new SnippetBuilder(conditionString.toString());
        Condition condition = new Condition();
        condition.setSnippet(snip.build(this.columnName));
        rule.addCondition(condition);
    }

    private void createColumnCondition(Rule rule, String value) {
        SnippetBuilder colSnip = new SnippetBuilder("$param : Column(name == \"$param\")");
        Condition colCondition = new Condition();
        colCondition.setSnippet(colSnip.build(value));
        rule.addCondition(colCondition);
    }

    public void addCondition(Rule rule) {
        this.createColumnCondition(rule, this.columnName);
        this.createCellCondition(rule);
    }

    public String getName() {
        return this.columnName;
    }

    public boolean isNotCondition() {
        return this.notCondition;
    }

    public String getCondition() {
        return this.condition;
    }
}

