/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

public class InvokeRemoteInterceptor
implements Interceptor,
Serializable {
    private static final Logger log = Logger.getLogger(InvokeRemoteInterceptor.class);
    private static final long serialVersionUID = -145166951731929406L;
    public static final InvokeRemoteInterceptor singleton = new InvokeRemoteInterceptor();
    public static final String REMOTING = "REMOTING";
    public static final String INVOKER_LOCATOR = "INVOKER_LOCATOR";
    public static final String SUBSYSTEM = "SUBSYSTEM";

    public String getName() {
        return "InvokeRemoteInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        InvokerLocator locator = (InvokerLocator)invocation.getMetaData(REMOTING, INVOKER_LOCATOR);
        if (locator == null) {
            throw new RuntimeException("No InvokerLocator supplied.  Can't invoke remotely!");
        }
        String subsystem = (String)invocation.getMetaData(REMOTING, SUBSYSTEM);
        if (subsystem == null) {
            subsystem = "AOP";
        }
        Client client = new Client(locator, subsystem);
        try {
            client.connect();
            InvocationResponse response = (InvocationResponse)client.invoke(invocation, null);
            invocation.setResponseContextInfo(response.getContextInfo());
            Object object = response.getResponse();
            return object;
        }
        catch (Exception e) {
            StackTraceElement[] serverStackTrace = e.getCause() != null ? e.getCause().getStackTrace() : e.getStackTrace();
            Exception clientException = new Exception();
            StackTraceElement[] clientStackTrace = clientException.getStackTrace();
            StackTraceElement[] completeStackTrace = new StackTraceElement[serverStackTrace.length + clientStackTrace.length];
            System.arraycopy(serverStackTrace, 0, completeStackTrace, 0, serverStackTrace.length);
            System.arraycopy(clientStackTrace, 0, completeStackTrace, serverStackTrace.length, clientStackTrace.length);
            if (e.getCause() != null) {
                e.getCause().setStackTrace(completeStackTrace);
            } else {
                e.setStackTrace(completeStackTrace);
            }
            throw e;
        }
        finally {
            client.disconnect();
        }
    }

    Object readResolve() throws ObjectStreamException {
        return singleton;
    }
}

