/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.ajax4jsf.framework.util.message.Messages;

public class HtmlDimensions {
    private static final Pattern PATTERN_NUMERIC = Pattern.compile("^[+-]?\\d+(\\.\\d+)?$");
    private static final Pattern PATTERN_PX = Pattern.compile("^[+-]?\\d+(\\.\\d+)?px$");
    private static final Pattern PATTERN_PCT = Pattern.compile("^[+-]?\\d+(\\.\\d+)?%$");
    private static final NumberFormat numericFormat = new DecimalFormat();
    private static final DecimalFormat pxFormat = new DecimalFormat();
    private static final NumberFormat pctFormat = NumberFormat.getPercentInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double decode(String size) {
        double d;
        block13: {
            d = 0.0;
            try {
                if (size == null) break block13;
                if (PATTERN_NUMERIC.matcher(size).matches()) {
                    NumberFormat numberFormat = numericFormat;
                    synchronized (numberFormat) {
                        d = numericFormat.parse(size).doubleValue();
                        break block13;
                    }
                }
                if (PATTERN_PX.matcher(size).matches()) {
                    DecimalFormat decimalFormat = pxFormat;
                    synchronized (decimalFormat) {
                        d = pxFormat.parse(size).doubleValue();
                        break block13;
                    }
                }
                if (!PATTERN_PCT.matcher(size).matches()) break block13;
                NumberFormat numberFormat = pctFormat;
                synchronized (numberFormat) {
                    d = pctFormat.parse(size).doubleValue();
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(Messages.getMessage(Messages.DECODE_PARAMETER_ERROR, new Object[]{"size", size, e.getMessage()}));
            }
        }
        return new Double(d);
    }

    public static String formatPx(Double value) {
        return value.intValue() + "px";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatPct(Double value) {
        String v = "";
        NumberFormat numberFormat = pctFormat;
        synchronized (numberFormat) {
            v = pctFormat.format(value);
        }
        return v;
    }

    static {
        pxFormat.setPositiveSuffix("px");
        pxFormat.setNegativeSuffix("px");
    }
}

