/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -4087936963051339868L;
    public static final String VIEW_BEAN_PREFIX = "org.ajax4jsf.viewbean:";
    public static final String VIEW_STATE_SAVED_PARAM = "org.ajax4jsf.VIEW_STATE_SAVED";
    private static final Log log = LogFactory.getLog((Class)AjaxPhaseListener.class);
    public static final String AJAX_BEAN_PREFIX = "org.ajax4jsf.ajaxviewbean:";

    public void afterPhase(PhaseEvent event) {
        UIViewRoot viewRoot;
        PhaseId phaseId = event.getPhaseId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process after phase " + phaseId.toString()));
        }
        FacesContext context = event.getFacesContext();
        Map requestMap = context.getExternalContext().getRequestMap();
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            if (ajaxContext.isAjaxRequest() && null == requestMap.get(VIEW_STATE_SAVED_PARAM)) {
                try {
                    ajaxContext.saveViewState(context);
                }
                catch (IOException e) {
                    throw new FacesException((Throwable)e);
                }
            }
        } else if (phaseId == PhaseId.RESTORE_VIEW && null != (viewRoot = context.getViewRoot())) {
            boolean isAjax = ajaxContext.isAjaxRequest();
            Map attributes = viewRoot.getAttributes();
            Iterator it = attributes.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                if (!(key instanceof String)) continue;
                String stringKey = (String)key;
                if (stringKey.startsWith(VIEW_BEAN_PREFIX)) {
                    requestMap.put(stringKey.substring(VIEW_BEAN_PREFIX.length()), attributes.get(key));
                    continue;
                }
                if (!isAjax || !stringKey.startsWith(AJAX_BEAN_PREFIX)) continue;
                requestMap.put(stringKey.substring(AJAX_BEAN_PREFIX.length()), attributes.get(key));
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process before phase " + phaseId.toString()));
        }
        FacesContext context = event.getFacesContext();
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            AjaxContext.getCurrentInstance(context).setViewIdHolder(null);
            UIViewRoot root = context.getViewRoot();
            log.debug((Object)Messages.getMessage(Messages.ENTER_BEFORE_RENDER_VIEW_PHASE, root.getViewId(), root.getRenderKitId()));
            String renderKitId = null;
            try {
                renderKitId = SkinFactory.getInstance().getSkin(context).getRenderKitId(context);
            }
            catch (Exception e) {
                log.error((Object)"Exception on get current Skin ", (Throwable)e);
            }
            if (null != renderKitId) {
                log.debug((Object)Messages.getMessage(Messages.SET_RENDER_KIT_ID_INFO, renderKitId));
                root.setRenderKitId(renderKitId);
            }
        } else if (phaseId == PhaseId.RESTORE_VIEW) {
            // empty if block
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    protected boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }
}

