/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.ajax;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.ajax4jsf.framework.ajax.JavaScriptParameter;
import org.ajax4jsf.framework.util.message.Messages;

public class UIActionParameter
extends UIParameter
implements ActionListener,
JavaScriptParameter {
    public static final String COMPONENT_TYPE = "org.ajax4jsf.components.UIActionParameter";
    private ValueBinding _assignToBinding = null;
    private Converter _converter = null;
    private Boolean _noEscape = null;
    private static String NO_ESCAPE_ATTR = "noEscape";

    public void setAssignToBinding(ValueBinding propertyBinding) {
        this._assignToBinding = propertyBinding;
    }

    public ValueBinding getAssignToBinding() {
        return this._assignToBinding;
    }

    public void setConverter(Converter converter) {
        this._converter = converter;
    }

    public Converter getConverter() {
        return this._converter;
    }

    public void setNoEscape(boolean noEscape) {
        this._noEscape = noEscape;
    }

    public boolean isNoEscape() {
        return this.isValueOrBinding(this._noEscape, NO_ESCAPE_ATTR);
    }

    public String getName() {
        String name = super.getName();
        if (null == name) {
            name = this.getClientId(FacesContext.getCurrentInstance());
        }
        return name;
    }

    public Object getValue() {
        Object value = super.getValue();
        if (null != value) {
            Converter converter;
            Class<?> type = value.getClass();
            FacesContext context = this.getFacesContext();
            if (type != null && !type.equals(String.class) && !type.equals(Object.class) && null != (converter = this.createConverter(context, type))) {
                value = converter.getAsString(context, (UIComponent)this, value);
            }
        }
        return value;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueBinding updateBinding = this.getAssignToBinding();
        if (updateBinding != null) {
            Class type;
            Object v = context.getExternalContext().getRequestParameterMap().get(this.getName());
            if (v != null && v instanceof String && (type = updateBinding.getType(context)) != null && !type.equals(String.class) && !type.equals(Object.class)) {
                Converter converter = this.createConverter(context, type);
                v = converter.getAsObject(context, (UIComponent)this, (String)v);
            }
            updateBinding.setValue(context, v);
        }
    }

    private Converter createConverter(FacesContext context, Class type) throws FacesException {
        Converter converter = this.getConverter();
        if (converter == null) {
            try {
                converter = context.getApplication().createConverter(type);
            }
            catch (Exception e) {
                throw new FacesException(Messages.getMessage(Messages.NO_CONVERTER_REGISTERED, type.getName()), (Throwable)e);
            }
        }
        return converter;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._assignToBinding = (ValueBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[1]);
        this._noEscape = (Boolean)values[2];
        this._converter = (Converter)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[3]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this._assignToBinding), this._noEscape, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this._converter)};
        return values;
    }

    private boolean isValueOrBinding(Boolean field, String name) {
        if (null != field) {
            return field;
        }
        ValueBinding vb = this.getValueBinding(name);
        if (null != vb) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        return false;
    }
}

