/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.mockejb.interceptor.Interceptor;

public class InvocationContext {
    private transient ListIterator iter;
    private Map contextProperties = new HashMap();
    private List interceptorList;
    private Object proxyObj;
    private Object targetObj;
    private Method targetMethod;
    private Method proxyMethod;
    private Object[] paramVals;
    private Object returnObject;
    private Throwable thrownThrowable;

    public InvocationContext(List interceptorList, Object proxyObj, Method proxyMethod, Object targetObj, Method targetMethod, Object[] paramVals) {
        this(interceptorList, proxyObj, proxyMethod, targetObj, targetMethod, paramVals, null);
    }

    public InvocationContext(List interceptorList, Object proxyObj, Method proxyMethod, Object targetObj, Method targetMethod, Object[] paramVals, Map contextProperties) {
        this.proxyObj = proxyObj;
        this.proxyMethod = proxyMethod;
        this.targetObj = targetObj;
        this.targetMethod = targetMethod;
        this.paramVals = paramVals;
        this.setInterceptorList(interceptorList);
        if (contextProperties != null) {
            this.contextProperties = new HashMap(contextProperties);
        }
    }

    public void setInterceptorList(List interceptorList) {
        this.verifyInterceptors(interceptorList);
        this.interceptorList = interceptorList;
        this.reset();
    }

    public List getInterceptorList() {
        return this.interceptorList;
    }

    public ListIterator getInterceptorIterator() {
        return this.iter;
    }

    private void verifyInterceptors(List interceptorList) {
        if (interceptorList == null) {
            throw new IllegalArgumentException("Interceptor list can't be null");
        }
        Iterator i = interceptorList.iterator();
        while (i.hasNext()) {
            Object interceptor = i.next();
            if (interceptor instanceof Interceptor) continue;
            throw new IllegalArgumentException("Object " + interceptor + " in the interceptor list does not implement interceptor interface");
        }
    }

    public void reset() {
        this.iter = this.interceptorList.listIterator();
    }

    public void clear() {
        this.reset();
        this.contextProperties.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proceed() throws Exception {
        if (!this.iter.hasPrevious()) {
            this.reset();
        }
        if (this.iter.hasNext()) {
            Interceptor nextInterceptor = (Interceptor)this.iter.next();
            try {
                nextInterceptor.intercept(this);
            }
            catch (Throwable throwable) {
                this.thrownThrowable = throwable;
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
            }
            finally {
                this.iter.previous();
            }
        }
    }

    public Object getProxyObject() {
        return this.proxyObj;
    }

    public Object getTargetObject() {
        return this.targetObj;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public Object getInterceptedObject() {
        return this.getProxyObject();
    }

    public Method getInterceptedMethod() {
        return this.getProxyMethod();
    }

    public Method getProxyMethod() {
        return this.proxyMethod;
    }

    public Object[] getParamVals() {
        return this.paramVals;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(Object returnObject) {
        this.returnObject = returnObject;
    }

    public Object getThrownThrowable() {
        return this.thrownThrowable;
    }

    public void setThrownThrowable(Throwable throwable) {
        this.thrownThrowable = throwable;
    }

    public void setContext(String key, Object data) {
        this.contextProperties.put(key, data);
    }

    public Object getPropertyValue(String key) {
        if (!this.contextProperties.containsKey(key)) {
            throw new IllegalStateException("Key " + key + " is not found in the invocation context");
        }
        return this.contextProperties.get(key);
    }

    public Object getOptionalPropertyValue(String key) {
        return this.contextProperties.get(key);
    }

    protected Object invokeMethod(Object targetObj, Method method, Object[] paramVals) throws Throwable {
        Object returnObj;
        if (targetObj == null) {
            throw new IllegalStateException("TargetObject is null during an attempt to call " + method + "\nOne of the interceptors should have handled target object invocation.");
        }
        try {
            returnObj = method.invoke(targetObj, paramVals);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        return returnObj;
    }

    public String toString() {
        return this.targetMethod.toString();
    }
}

