/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import org.mockejb.interceptor.Aspect;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.InvocationContext;
import org.mockejb.interceptor.Pointcut;

class InterceptorContainerAspect
implements Aspect {
    private Pointcut pointcut;
    private Interceptor interceptor;

    public InterceptorContainerAspect(Pointcut pointcut, Interceptor interceptor) {
        if (pointcut == null) {
            throw new IllegalArgumentException("Interceptor can't be null");
        }
        if (interceptor == null) {
            throw new IllegalArgumentException("Pointcut can't be null");
        }
        this.pointcut = pointcut;
        this.interceptor = interceptor;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void intercept(InvocationContext invocationContext) throws Exception {
        this.interceptor.intercept(invocationContext);
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InterceptorContainerAspect)) {
            return false;
        }
        InterceptorContainerAspect aspect = (InterceptorContainerAspect)obj;
        return this.pointcut.equals(aspect.pointcut) && this.interceptor.equals(aspect.interceptor);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.pointcut.hashCode();
        result = 37 * result + this.interceptor.hashCode();
        return result;
    }
}

