/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javassist.bytecode.annotation.Annotation;
import org.jboss.aop.annotation.ProxyMapCreator;

public class AnnotationProxy
implements InvocationHandler {
    Map map;

    public AnnotationProxy(Map valueMap) {
        this.map = valueMap;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals")) {
            return this.doEquals(proxy, args[0]);
        }
        if (method.getName().equals("hashCode")) {
            return this.doHashCode();
        }
        if (method.getName().equals("toString")) {
            return this.map.toString();
        }
        return this.map.get(method.getName());
    }

    private Object doEquals(Object proxy, Object obj) {
        if (obj == proxy) {
            return Boolean.TRUE;
        }
        if (obj == null) {
            return Boolean.FALSE;
        }
        Class<?>[] intfs = proxy.getClass().getInterfaces();
        if (!intfs[0].isAssignableFrom(obj.getClass())) {
            return Boolean.FALSE;
        }
        try {
            Proxy.getInvocationHandler(obj);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object doHashCode() {
        return new Integer(((Object)this.map).hashCode());
    }

    public static Object createProxy(Annotation info) throws Exception {
        Class<?> annotation = Thread.currentThread().getContextClassLoader().loadClass(info.getTypeName());
        return AnnotationProxy.createProxy(info, annotation);
    }

    public static Object createProxy(Annotation info, Class annotation) throws Exception {
        Map map = ProxyMapCreator.createProxyMap(annotation, info);
        AnnotationProxy proxyHandler = new AnnotationProxy(map);
        return Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, (InvocationHandler)proxyHandler);
    }

    public static Object createProxy(Map map, Class annotation) throws Exception {
        AnnotationProxy proxyHandler = new AnnotationProxy(map);
        return Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, (InvocationHandler)proxyHandler);
    }
}

