/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.aop.util.FieldComparator;
import org.jboss.aop.util.MethodHashing;

public class ClassContainer
extends Advisor {
    protected Field[] advisedFields;

    public ClassContainer(String name, AspectManager manager) {
        super(name, manager);
    }

    public void initializeClassContainer() {
        this.initializeMetadata();
        this.rebuildInterceptors();
    }

    public void setClass(Class clazz) {
        this.clazz = clazz;
    }

    public void initializeMetadata() {
        this.createMethodMap();
        this.createConstructorTables();
        this.createFieldTable();
        this.rebindClassMetaData();
        this.deployAnnotationOverrides();
    }

    private void populateFieldTable(ArrayList fields, Class superclass) {
        if (superclass == null) {
            return;
        }
        if (superclass.equals(Object.class)) {
            return;
        }
        this.populateFieldTable(fields, superclass.getSuperclass());
        ArrayList<Field> temp = new ArrayList<Field>();
        Field[] declaredFields = superclass.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!ClassAdvisor.isAdvisable(declaredFields[i])) continue;
            temp.add(declaredFields[i]);
        }
        Collections.sort(temp, FieldComparator.INSTANCE);
        fields.addAll(temp);
    }

    private void createFieldTable() {
        ArrayList fields = new ArrayList();
        this.populateFieldTable(fields, this.clazz);
        this.advisedFields = fields.toArray(new Field[fields.size()]);
    }

    protected void rebuildInterceptors() {
        this.adviceBindings.clear();
        this.createInterceptorChains();
    }

    public void addClassMetaData(ClassMetaDataBinding data) {
        this.classMetaDataBindings.add(data);
        if (this.clazz == null) {
            return;
        }
        this.bindClassMetaData(data);
        this.adviceBindings.clear();
        this.doesHaveAspects = false;
        this.rebuildInterceptors();
    }

    public void removeClassMetaData(ClassMetaDataBinding data) {
        if (this.classMetaDataBindings.remove(data)) {
            if (this.clazz == null) {
                return;
            }
            this.rebindClassMetaData();
            this.adviceBindings.clear();
            this.doesHaveAspects = false;
            this.rebuildInterceptors();
        }
    }

    protected void bindClassMetaData(ClassMetaDataBinding data) {
        try {
            ClassMetaDataLoader loader = data.getLoader();
            Object[] objs = this.advisedMethods.getValues();
            Method[] methods = new Method[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                methods[i] = (Method)objs[i];
            }
            loader.bind((Advisor)this, data, methods, this.advisedFields, this.clazz.getDeclaredConstructors());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void rebindClassMetaData() {
        this.defaultMetaData.clear();
        this.methodMetaData.clear();
        this.fieldMetaData.clear();
        this.constructorMetaData.clear();
        this.classMetaData.clear();
        for (int i = 0; i < this.classMetaDataBindings.size(); ++i) {
            ClassMetaDataBinding data = (ClassMetaDataBinding)this.classMetaDataBindings.get(i);
            this.bindClassMetaData(data);
        }
    }

    protected void createMethodMap() {
        try {
            Method[] declaredMethods = this.clazz.getMethods();
            for (int i = 0; i < declaredMethods.length; ++i) {
                if (!ClassAdvisor.isAdvisable(declaredMethods[i])) continue;
                long hash = MethodHashing.methodHash(declaredMethods[i]);
                this.advisedMethods.put(hash, (Object)declaredMethods[i]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TLongObjectHashMap initializeMethodChain() {
        TLongObjectHashMap newInterceptors = new TLongObjectHashMap();
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            Method amethod;
            MethodInfo info = new MethodInfo();
            info.advisedMethod = amethod = (Method)this.advisedMethods.get(keys[i]);
            info.unadvisedMethod = amethod;
            info.hash = keys[i];
            info.advisor = this;
            newInterceptors.put(keys[i], (Object)info);
        }
        return newInterceptors;
    }

    protected void createConstructorTables() {
        this.constructors = this.clazz.getDeclaredConstructors();
        for (int i = 0; i < this.constructors.length; ++i) {
            this.constructors[i].setAccessible(true);
        }
        Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
    }

    protected void createInterceptorChains() {
        TLongObjectHashMap newMethodInterceptors = this.initializeMethodChain();
        ArrayList newConstructorInterceptors = this.initializeConstructorChain();
        Iterator it = this.manager.getBindings().values().iterator();
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (AspectManager.verbose) {
                System.out.println("iterate binding " + binding.getName());
            }
            this.resolveMethodPointcut(newMethodInterceptors, binding);
            this.resolveConstructorPointcut(newConstructorInterceptors, binding);
        }
        this.finalizeConstructorChain(newConstructorInterceptors);
        this.finalizeMethodChain(newMethodInterceptors);
        this.constructorInterceptors = (Interceptor[][])newConstructorInterceptors.toArray((T[])new Interceptor[0][0]);
        this.methodInterceptors = newMethodInterceptors;
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }
}

