/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.model.support.PropertiesMap;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.report.JUnitReportCollector;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class SoapUITestCaseRunner
implements TestRunListener {
    private static final Logger log = Logger.getLogger(SoapUITestCaseRunner.class);
    private String projectFile;
    private String testSuite;
    private String testCase;
    private List<WsdlMessageAssertion> assertions = new ArrayList<WsdlMessageAssertion>();
    private Map<WsdlMessageAssertion, WsdlTestStepResult> assertionResults = new HashMap<WsdlMessageAssertion, WsdlTestStepResult>();
    private List<TestCase> runningTests = new ArrayList<TestCase>();
    private List<TestCase> failedTests = new ArrayList<TestCase>();
    private String endpoint;
    private String domain;
    private String password;
    private String username;
    private String host;
    private int testSuiteCount;
    private int testCaseCount;
    private int testStepCount;
    private int testAssertionCount;
    private boolean printReport;
    private String outputFolder;
    private boolean exportAll;
    private boolean junitReport;
    private int exportCount;
    private JUnitReportCollector reportCollector;
    private String wssPasswordType;
    public static String TITLE = "soapUI 1.7.1 TestCase Runner";

    public static void main(String[] args) throws Exception {
        System.out.println(TITLE);
        SoapUI.initSoapUILog();
        SoapUITestCaseRunner runner = new SoapUITestCaseRunner();
        Options options = new Options();
        options.addOption("e", true, "Sets the endpoint");
        options.addOption("s", true, "Sets the testsuite");
        options.addOption("c", true, "Sets the testcase");
        options.addOption("u", true, "Sets the username");
        options.addOption("p", true, "Sets the password");
        options.addOption("w", true, "Sets the WSS password type, either 'Text' or 'Digest'");
        options.addOption("d", true, "Sets the domain");
        options.addOption("h", true, "Sets the host");
        options.addOption("r", false, "Prints a small summary report");
        options.addOption("f", true, "Sets the output folder to export results to");
        options.addOption("j", false, "Sets the output to include JUnit XML reports");
        options.addOption("a", false, "Turns on exporting of all results");
        options.addOption("t", true, "Sets the soapui-settings.xml file to use");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        String[] args2 = cmd.getArgs();
        if (args2.length != 1) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("testcaserunner [options] <soapui-project-file>", options);
            System.err.println("Missing soapUI project file..");
            return;
        }
        runner.setProjectFile(args2[0]);
        if (cmd.hasOption("e")) {
            runner.setEndpoint(cmd.getOptionValue("e"));
        }
        if (cmd.hasOption("s")) {
            runner.setTestSuite(cmd.getOptionValue("s"));
        }
        if (cmd.hasOption("c")) {
            runner.setTestCase(cmd.getOptionValue("c"));
        }
        if (cmd.hasOption("u")) {
            runner.setUsername(cmd.getOptionValue("u"));
        }
        if (cmd.hasOption("p")) {
            runner.setPassword(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("w")) {
            runner.setWssPasswordType(cmd.getOptionValue("w"));
        }
        if (cmd.hasOption("d")) {
            runner.setDomain(cmd.getOptionValue("d"));
        }
        if (cmd.hasOption("h")) {
            runner.setHost(cmd.getOptionValue("h"));
        }
        if (cmd.hasOption("f")) {
            runner.setOutputFolder(cmd.getOptionValue("f"));
        }
        if (cmd.hasOption("t")) {
            SoapUI.initSettings(cmd.getOptionValue("t"));
        }
        runner.setPrintReport(cmd.hasOption("r"));
        runner.setExportAll(cmd.hasOption("a"));
        runner.setJUnitReport(cmd.hasOption("j"));
        try {
            SoapUI.loadExtLibs();
            SoapUITestCaseRunner.initGroovyLogger();
            runner.run();
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void initGroovyLogger() {
        Logger logger = Logger.getLogger((String)"groovy.log");
        ConsoleAppender appender = new ConsoleAppender();
        appender.setWriter((Writer)new OutputStreamWriter(System.out));
        appender.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %-5p [%c{1}] %m%n"));
        logger.addAppender((Appender)appender);
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public void setJUnitReport(boolean junitReport) {
        this.junitReport = junitReport;
        if (junitReport) {
            this.reportCollector = new JUnitReportCollector();
        }
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public SoapUITestCaseRunner() {
        SoapUI.setTestMonitor(new TestMonitor());
    }

    public void setPrintReport(boolean printReport) {
        this.printReport = printReport;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDomain(String domain) {
        log.info((Object)("Setting domain to [" + domain + "]"));
        this.domain = domain;
    }

    public void setPassword(String password) {
        log.info((Object)("Setting password to [" + password + "]"));
        this.password = password;
    }

    public void setWssPasswordType(String wssPasswordType) {
        this.wssPasswordType = wssPasswordType;
    }

    public void setUsername(String username) {
        log.info((Object)("Setting username to [" + username + "]"));
        this.username = username;
    }

    public void run() throws Exception {
        int c;
        this.assertions.clear();
        if (!new File(this.projectFile).exists()) {
            throw new Exception("soapUI project file [" + this.projectFile + "] not found");
        }
        WsdlProject project = new WsdlProject(this.projectFile, null);
        log.info((Object)("Running soapUI tests in project [" + project.getName() + "]"));
        long startTime = System.nanoTime();
        for (c = 0; c < project.getTestSuiteCount(); ++c) {
            WsdlTestSuite suite = project.getTestSuiteAt(c);
            for (int i = 0; i < suite.getTestCaseCount(); ++i) {
                suite.getTestCaseAt(i).addTestRunListener(this);
                if (!this.junitReport) continue;
                suite.getTestCaseAt(i).addTestRunListener(this.reportCollector);
            }
        }
        for (c = 0; c < project.getTestSuiteCount(); ++c) {
            if (this.testSuite != null && !project.getTestSuiteAt(c).getName().equalsIgnoreCase(this.testSuite)) continue;
            this.runSuite(project.getTestSuiteAt(c));
            ++this.testSuiteCount;
            if (!this.runningTests.isEmpty()) {
                log.info((Object)("Waiting for " + this.runningTests.size() + " tests to finish"));
            }
            while (!this.runningTests.isEmpty()) {
                Thread.sleep(100L);
            }
        }
        long timeTaken = (System.nanoTime() - startTime) / 1000000L;
        if (this.printReport) {
            System.out.println();
            System.out.println("SoapUI 1.7.1 TestCaseRunner Summary");
            System.out.println("-----------------------------");
            System.out.println("Time Taken: " + timeTaken + "ms");
            System.out.println("Total TestSuites: " + this.testSuiteCount);
            System.out.println("Total TestCases: " + this.testCaseCount + " (" + this.failedTests.size() + " failed)");
            System.out.println("Total TestSteps: " + this.testStepCount);
            System.out.println("Total Request Assertions: " + this.testAssertionCount);
            System.out.println("Total Failed Assertions: " + this.assertions.size());
            System.out.println("Total Exported Results: " + this.exportCount);
        }
        if (this.junitReport) {
            this.reportCollector.saveReports(this.outputFolder == null ? "" : this.outputFolder);
        }
        if (this.assertions.size() > 0 || this.failedTests.size() > 0) {
            StringBuffer buf = new StringBuffer();
            for (int c2 = 0; c2 < this.assertions.size(); ++c2) {
                WsdlMessageAssertion assertion = this.assertions.get(c2);
                WsdlTestRequest testRequest = (WsdlTestRequest)assertion.getAssertable();
                this.failedTests.remove(testRequest.getTestCase());
                buf.append(assertion.getName() + " in [" + testRequest.getName() + "] failed;\n");
                buf.append(Arrays.toString(assertion.getErrors()) + "\n");
                WsdlTestStepResult result = this.assertionResults.get(assertion);
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                result.writeTo(writer);
                buf.append(stringWriter.toString());
            }
            while (!this.failedTests.isEmpty()) {
                buf.append("TestCase [" + this.failedTests.remove(0).getName() + "] failed without assertions\n");
            }
            throw new Exception(buf.toString());
        }
    }

    public void runSuite(TestSuite suite) {
        log.info((Object)("Running soapUI suite [" + suite.getName() + "], runType = " + (Object)((Object)suite.getRunType())));
        long start = System.currentTimeMillis();
        for (int c = 0; c < suite.getTestCaseCount(); ++c) {
            String name = suite.getTestCaseAt(c).getName();
            if (this.testCase == null || name.equalsIgnoreCase(this.testCase)) {
                this.runTestCase(suite.getTestCaseAt(c));
                continue;
            }
            log.info((Object)("Skipping testcase [" + name + "], filter is [" + this.testCase + "]"));
        }
        log.info((Object)("soapUI suite [" + suite.getName() + "] finished in " + (System.currentTimeMillis() - start) + "ms"));
    }

    private void runTestCase(TestCase testCase) {
        this.runningTests.add(testCase);
        testCase.run(PropertiesMap.EMPTY_MAP, testCase.getTestSuite().getRunType() == TestSuite.TestSuiteRunType.PARALLEL);
    }

    public void setProjectFile(String projectFile) {
        log.info((Object)("setting projectFile to [" + projectFile + "]"));
        this.projectFile = projectFile;
    }

    public void setTestCase(String testCase) {
        log.info((Object)("setting testCase to [" + testCase + "]"));
        this.testCase = testCase;
    }

    public void setEndpoint(String endpoint) {
        log.info((Object)("setting test endpoint to [" + endpoint + "]"));
        this.endpoint = endpoint.trim();
    }

    public void setTestSuite(String testSuite) {
        log.info((Object)("setting testSuite to [" + testSuite + "]"));
        this.testSuite = testSuite;
    }

    public void beforeRun(TestRunner testRunner, TestRunContext runContext) {
        log.info((Object)("Running soapUI testcase [" + testRunner.getTestCase().getName() + "]"));
    }

    public void beforeStep(TestRunner testRunner, TestRunContext runContext) {
        TestStep currentStep = runContext.getCurrentStep();
        log.info((Object)("running step [" + currentStep.getName() + "]"));
        if (currentStep instanceof WsdlTestRequestStep) {
            WsdlTestRequestStep requestStep = (WsdlTestRequestStep)currentStep;
            if (this.endpoint != null && this.endpoint.length() > 0) {
                requestStep.getTestRequest().setEndpoint(this.endpoint);
            }
            if (this.host != null && this.host.length() > 0) {
                try {
                    String ep = SoapUITestCaseRunner.replaceHost(requestStep.getTestRequest().getEndpoint(), this.host);
                    requestStep.getTestRequest().setEndpoint(ep);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to set host on endpoint", (Throwable)e);
                }
            }
            if (this.username != null && this.username.length() > 0) {
                requestStep.getTestRequest().setUsername(this.username);
            }
            if (this.password != null && this.password.length() > 0) {
                requestStep.getTestRequest().setPassword(this.password);
            }
            if (this.domain != null && this.domain.length() > 0) {
                requestStep.getTestRequest().setDomain(this.domain);
            }
            if (this.wssPasswordType != null && this.wssPasswordType.length() > 0) {
                requestStep.getTestRequest().setWssPasswordType(this.wssPasswordType.equals("Digest") ? "PasswordDigest" : "PasswordText");
            }
        }
    }

    public void afterStep(TestRunner testRunner, TestRunContext runContext, TestStepResult result) {
        String countPropertyName;
        Long count;
        TestStep currentStep = runContext.getCurrentStep();
        if (currentStep instanceof WsdlTestRequestStep) {
            WsdlTestRequestStep requestStep = (WsdlTestRequestStep)currentStep;
            for (int c = 0; c < requestStep.getAssertionCount(); ++c) {
                WsdlMessageAssertion assertion = requestStep.getAssertionAt(c);
                log.info((Object)("Assertion [" + assertion.getName() + "] has status " + (Object)((Object)assertion.getStatus())));
                if (assertion.getStatus() == Assertable.AssertionStatus.FAILED) {
                    log.info((Object)("ASSERTION FAILED -> " + assertion.getErrors()));
                    this.assertions.add(assertion);
                    this.assertionResults.put(assertion, (WsdlTestStepResult)result);
                }
                ++this.testAssertionCount;
            }
        }
        if ((count = (Long)runContext.getProperty(countPropertyName = currentStep.getName() + " run count")) == null) {
            count = new Long(0L);
        }
        runContext.setProperty(countPropertyName, new Long(count + 1L));
        if (result.getStatus() == TestStepResult.TestStepStatus.FAILED || this.exportAll) {
            try {
                String fileName = currentStep.getTestCase().getTestSuite().getName() + "-" + currentStep.getTestCase().getName() + "-" + currentStep.getName() + "-" + count + "-" + (Object)((Object)result.getStatus()) + ".txt";
                if (this.outputFolder != null) {
                    File folder = new File(this.outputFolder);
                    if (!folder.exists()) {
                        folder.mkdirs();
                    }
                    fileName = this.outputFolder + File.separator + fileName;
                }
                if (result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                    log.error((Object)(currentStep.getName() + " failed, exporting to [" + fileName + "]"));
                }
                PrintWriter writer = new PrintWriter(fileName);
                result.writeTo(writer);
                writer.close();
                ++this.exportCount;
            }
            catch (Exception e) {
                log.error((Object)("Error saving failed result: " + e), (Throwable)e);
            }
        }
        ++this.testStepCount;
    }

    public void afterRun(TestRunner testRunner, TestRunContext runContext) {
        log.info((Object)("Finished running soapUI testcase [" + testRunner.getTestCase().getName() + "], time taken: " + testRunner.getTimeTaken() + "ms, status: " + (Object)((Object)testRunner.getStatus())));
        if (testRunner.getStatus() == TestRunner.Status.FAILED) {
            this.failedTests.add(testRunner.getTestCase());
        }
        this.runningTests.remove(testRunner.getTestCase());
        ++this.testCaseCount;
    }

    public static String replaceHost(String endpoint, String host) {
        int ix1 = endpoint.indexOf("://");
        if (ix1 < 0) {
            return endpoint;
        }
        int ix2 = endpoint.indexOf(":", ix1 + 3);
        if ((ix2 == -1 || host.indexOf(":") > 0) && (ix2 = endpoint.indexOf("/", ix1 + 3)) == ix1 + 3) {
            ix2 = -1;
        }
        return endpoint.substring(0, ix1) + "://" + host + (ix2 == -1 ? "" : endpoint.substring(ix2));
    }
}

