/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.SwingActionDelegate;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingActionRegistry {
    private Map<String, ActionMapping> actions = new HashMap<String, ActionMapping>();
    private static SwingActionRegistry instance;

    public <T> Action getAction(Class<? extends SoapUIAction<T>> actionClass, T target) {
        ActionMapping mapping = this.actions.get(actionClass.getName());
        if (mapping == null) {
            return null;
        }
        return new SwingActionDelegate(mapping.getAction(), target, mapping.getIcon(), mapping.getKeyStroke());
    }

    public <T> Action getAction(Class<? extends SoapUIAction<T>> actionClass, T target, String name, String description) {
        Action action = this.getAction(actionClass, target);
        if (action != null) {
            if (name != null) {
                action.putValue("Name", name);
            }
            if (description != null) {
                action.putValue("ShortDescription", description);
            }
        }
        return action;
    }

    public void mapAction(SoapUIAction<?> action, String keyStroke, String iconResource) {
        ActionMapping mapping = new ActionMapping(action, keyStroke, iconResource);
        this.actions.put(action.getClass().getName(), mapping);
    }

    public static SwingActionRegistry getInstance() {
        if (instance == null) {
            instance = new SwingActionRegistry();
        }
        return instance;
    }

    public static <T> Action get(Class<? extends SoapUIAction<T>> actionClass, T target) {
        return SwingActionRegistry.getInstance().getAction(actionClass, target);
    }

    public static <T> Action get(Class<? extends SoapUIAction<T>> actionClass, T target, String name, String description) {
        return SwingActionRegistry.getInstance().getAction(actionClass, target, name, description);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ActionMapping {
        private final SoapUIAction<?> action;
        private final String keyStroke;
        private final String iconResource;
        private ImageIcon icon;

        public ActionMapping(SoapUIAction<?> action, String keyStroke, String iconResource) {
            this.action = action;
            this.keyStroke = keyStroke;
            this.iconResource = iconResource;
        }

        public SoapUIAction<?> getAction() {
            return this.action;
        }

        public String getIconResource() {
            return this.iconResource;
        }

        public Icon getIcon() {
            if (this.iconResource == null) {
                return null;
            }
            if (this.icon == null) {
                this.icon = UISupport.createImageIcon(this.iconResource);
            }
            return this.icon;
        }

        public String getKeyStroke() {
            return this.keyStroke;
        }
    }
}

