/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Tools {
    public static final int COPY_BUFFER_SIZE = 1000;
    private static final String errMsg = "Error attempting to launch web browser";
    private static final byte[] copyBuffer = new byte[8192];
    public static final long READ_ALL = 0L;

    public static String[] tokenizeArgs(String args) {
        if (args == null || args.trim().length() == 0) {
            return null;
        }
        List<String> l = Arrays.asList(args.split(" "));
        ArrayList<String> result = new ArrayList<String>();
        for (int c = 0; c < l.size(); ++c) {
            String s = l.get(c);
            if (s.startsWith("\"")) {
                s = s + " " + l.get(++c);
                while ((!s.endsWith("\"") || s.endsWith("\\\"")) && c < l.size()) {
                    ++c;
                }
                s = c == l.size() ? s.substring(1) : s.substring(1, s.length() - 1);
                s = s.replace("\\\"", "\"");
            }
            result.add(s);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getFilename(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return filePath;
        }
        int ix = filePath.lastIndexOf(File.separatorChar);
        if (ix <= 0) {
            return filePath;
        }
        return filePath.substring(ix + 1, filePath.length());
    }

    public static String getDir(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return filePath;
        }
        int ix = filePath.lastIndexOf(File.separatorChar);
        if (ix <= 0) {
            return filePath;
        }
        return Tools.ensureDir(filePath.substring(0, ix), "");
    }

    public static String ensureDir(String dir, String basedir) {
        if (dir == null || dir.length() == 0) {
            return "";
        }
        File dirFile = new File(dir);
        if (!dirFile.isAbsolute()) {
            if (basedir.length() == 0) {
                basedir = new File("").getAbsolutePath();
            }
            dirFile = new File(basedir, dir);
        }
        dirFile.mkdirs();
        return dirFile.getAbsolutePath();
    }

    public static String ensureFileDir(String file, String basedir) {
        if (file == null || file.length() == 0) {
            return "";
        }
        File dirFile = new File(basedir, file);
        if (!dirFile.isAbsolute()) {
            if (basedir.length() == 0) {
                basedir = new File("").getAbsolutePath();
            }
            dirFile = new File(basedir, file);
        }
        String absolutePath = dirFile.getAbsolutePath();
        if (!dirFile.exists()) {
            int ix = absolutePath.lastIndexOf(File.separatorChar);
            File fileDir = new File(absolutePath.substring(0, ix));
            fileDir.mkdirs();
        }
        return absolutePath;
    }

    public static String ensureDir(String outputDir) {
        if (outputDir == null) {
            outputDir = "";
        }
        File output = new File(outputDir);
        output.mkdirs();
        return outputDir;
    }

    public static void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                if (url.startsWith("file:")) {
                    Runtime.getRuntime().exec("cmd.exe /C explorer " + url);
                } else {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                }
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    public static ByteArrayOutputStream readAll(InputStream instream, long maxSize) throws IOException {
        int len;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        int read = 0;
        int toRead = 4096;
        if (maxSize > 0L && (long)(read + toRead) > maxSize) {
            toRead = (int)(maxSize - (long)read);
        }
        while ((len = instream.read(buffer, 0, toRead)) > 0) {
            outstream.write(buffer, 0, len);
            if (maxSize <= 0L || (long)((read += toRead) + toRead) <= maxSize) continue;
            toRead = (int)(maxSize - (long)read);
        }
        outstream.close();
        return outstream;
    }

    public static int copyFile(File source, File target, boolean overwrite2) throws IOException {
        File pathFile;
        String path;
        int ix;
        int bytes = 0;
        if (overwrite2 && target.exists()) {
            target.delete();
        } else if (!target.exists() && (ix = (path = target.getAbsolutePath()).lastIndexOf(File.separatorChar)) != -1 && !(pathFile = new File(path = path.substring(0, ix))).exists()) {
            pathFile.mkdirs();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        int read = in.read(copyBuffer);
        while (read != -1) {
            if (read > 0) {
                out.write(copyBuffer, 0, read);
                bytes += read;
            }
            read = in.read(copyBuffer);
        }
        in.close();
        out.close();
        return bytes;
    }

    public static String joinRelativeUrl(String baseUrl, String url) {
        int ix2;
        boolean isFile = baseUrl.startsWith("file:");
        int ix = baseUrl.lastIndexOf(92);
        if (ix == -1) {
            ix = baseUrl.lastIndexOf(47);
        }
        while (url.startsWith(".\\") || url.startsWith("./")) {
            url = url.substring(2);
        }
        while (url.startsWith("../") || url.startsWith("..\\")) {
            ix2 = baseUrl.lastIndexOf(92, ix - 1);
            if (ix2 == -1) {
                ix2 = baseUrl.lastIndexOf(47, ix - 1);
            }
            if (ix2 == -1) break;
            baseUrl = baseUrl.substring(0, ix2 + 1);
            ix = ix2;
            url = url.substring(3);
        }
        while (url.indexOf("/./") != -1 || url.indexOf("\\.\\") != -1) {
            ix2 = url.indexOf("/./");
            if (ix2 == -1) {
                ix2 = url.indexOf("\\.\\");
            }
            url = url.substring(0, ix2) + url.substring(ix2 + 2);
        }
        while (url.indexOf("/../") != -1 || url.indexOf("\\..\\") != -1) {
            ix2 = -1;
            int ix3 = url.indexOf("/../");
            if (ix3 == -1) {
                ix3 = url.indexOf("\\..\\");
                ix2 = url.lastIndexOf(92, ix3 - 1);
            } else {
                ix2 = url.lastIndexOf(47, ix3 - 1);
            }
            if (ix2 == -1) break;
            url = url.substring(0, ix2) + url.substring(ix3 + 3);
        }
        String result = baseUrl.substring(0, ix + 1) + url;
        if (isFile) {
            result = result.replace('/', File.separatorChar);
        }
        return result;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static long writeAll(OutputStream out, InputStream in) throws IOException {
        byte[] buffer = new byte[1000];
        long total = 0L;
        int sz = in.read(buffer);
        while (sz != -1) {
            out.write(buffer, 0, sz);
            total += (long)sz;
            sz = in.read(buffer);
        }
        return total;
    }

    public static String expandProperties(StringToStringMap values, String content, boolean leaveMissing) {
        int ix = content.indexOf("${");
        if (ix == -1) {
            return content;
        }
        StringBuffer buf = new StringBuffer();
        int lastIx = 0;
        while (ix != -1) {
            String propertyName;
            Object property;
            buf.append(content.substring(lastIx, ix));
            int ix2 = content.indexOf(125, ix + 2);
            if (ix2 == -1) break;
            int ix3 = content.lastIndexOf("${", ix2);
            if (ix3 != ix) {
                buf.append(content.substring(ix, ix3));
                ix = ix3;
            }
            if ((property = values.get(propertyName = content.substring(ix + 2, ix2))) != null) {
                buf.append(property.toString());
            } else if (leaveMissing) {
                buf.append("${").append(propertyName).append('}');
            }
            lastIx = ix2 + 1;
            ix = content.indexOf("${", lastIx);
        }
        if (lastIx < content.length()) {
            buf.append(content.substring(lastIx));
        }
        return buf.toString();
    }
}

