/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.monitor;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.soap.SoapMessageBuilder;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.log.JettyLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;

public class MockEngine {
    private static final Logger log = Logger.getLogger(MockEngine.class);
    private Server server;
    private Map<Integer, Map<String, MockRunner>> runners = new HashMap<Integer, Map<String, MockRunner>>();
    private Map<Integer, SoapUIConnector> connectors = new HashMap<Integer, SoapUIConnector>();
    private List<MockRunner> mockRunners = new ArrayList<MockRunner>();

    public MockEngine() {
        System.setProperty("org.mortbay.log.class", JettyLogger.class.getName());
    }

    public boolean hasRunningMock(MockService mockService) {
        return false;
    }

    public void startMockService(MockRunner runner) throws Exception {
        MockService mockService;
        int port;
        if (this.server == null) {
            this.initServer();
        }
        if (!this.runners.containsKey(port = (mockService = runner.getMockService()).getPort())) {
            SoapUIConnector connector;
            block5: {
                connector = new SoapUIConnector();
                connector.setPort(port);
                boolean wasRunning = this.server.isRunning();
                if (wasRunning) {
                    this.server.stop();
                }
                this.server.addConnector((Connector)connector);
                try {
                    this.server.start();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    UISupport.showErrorMessage(e);
                    this.server.removeConnector((Connector)connector);
                    if (!wasRunning) break block5;
                    this.server.start();
                    return;
                }
            }
            this.connectors.put(new Integer(port), connector);
            this.runners.put(new Integer(port), new HashMap());
        }
        Map<String, MockRunner> map = this.runners.get(port);
        String path = mockService.getPath();
        map.put(path, runner);
        this.mockRunners.add(runner);
        log.info((Object)("Started mockService [" + mockService.getName() + "] on port [" + port + "] at path [" + path + "]"));
    }

    private void initServer() throws Exception {
        this.server = new Server();
        BoundedThreadPool threadPool = new BoundedThreadPool();
        threadPool.setMaxThreads(100);
        this.server.setThreadPool((ThreadPool)threadPool);
        this.server.setHandler((Handler)new ServerHandler());
    }

    public void stopMockService(WsdlMockRunner runner) {
        WsdlMockService mockService = runner.getMockService();
        Integer port = new Integer(mockService.getPort());
        Map<String, MockRunner> map = this.runners.get(port);
        map.remove(mockService.getPath());
        this.mockRunners.remove(runner);
        if (map.isEmpty()) {
            SoapUIConnector connector = this.connectors.get(port);
            if (connector == null) {
                log.warn((Object)("Missing connectors on port [" + port + "]"));
                return;
            }
            try {
                log.info((Object)("Stopping connector on port " + port));
                if (!connector.waitUntilIdle(5000L)) {
                    log.warn((Object)"Failed to wait for idle.. stopping connector anyway..");
                }
                connector.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.server.removeConnector((Connector)connector);
            this.runners.remove(port);
            if (this.runners.isEmpty()) {
                try {
                    log.info((Object)"No more connectors.. stopping server");
                    this.server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public MockRunner[] getMockRunners() {
        return this.mockRunners.toArray(new MockRunner[this.mockRunners.size()]);
    }

    private class ServerHandler
    extends AbstractHandler {
        private ServerHandler() {
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            MockRunner wsdlMockRunner;
            Map map = (Map)MockEngine.this.runners.get(request.getLocalPort());
            if (map != null && (wsdlMockRunner = (MockRunner)map.get(request.getPathInfo())) != null) {
                try {
                    WsdlMockResult result = (WsdlMockResult)wsdlMockRunner.dispatchRequest(request, response);
                    result.finish();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SoapMessageBuilder messageBuilder = (SoapMessageBuilder)wsdlMockRunner.getMockService().getProject().getInterfaceAt(0).getMessageBuilder();
                    response.getWriter().print(messageBuilder.buildFault("Server", e.getMessage()));
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }

    private class SoapUIConnector
    extends SelectChannelConnector {
        private Set<HttpConnection> connections = new HashSet<HttpConnection>();

        private SoapUIConnector() {
        }

        protected void connectionClosed(HttpConnection arg0) {
            super.connectionClosed(arg0);
            this.connections.remove(arg0);
        }

        protected void connectionOpened(HttpConnection arg0) {
            super.connectionOpened(arg0);
            this.connections.add(arg0);
        }

        public boolean waitUntilIdle(long maxwait) throws Exception {
            while (maxwait > 0L && this.hasActiveConnections()) {
                System.out.println("Waiting for active connections to finish..");
                Thread.sleep(500L);
                maxwait -= 500L;
            }
            return !this.hasActiveConnections();
        }

        private boolean hasActiveConnections() {
            for (HttpConnection connection : this.connections) {
                if (connection.isIdle()) continue;
                return true;
            }
            return false;
        }
    }
}

