/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.WorkspaceTreeNode;
import com.eviware.soapui.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapUITreeModel
implements TreeModel {
    private Set<TreeModelListener> listeners = new HashSet<TreeModelListener>();
    private SoapUITreeNode workspaceNode;
    private static final Logger logger = Logger.getLogger(SoapUITreeModel.class);
    private Map<ModelItem, SoapUITreeNode> modelItemMap = new HashMap<ModelItem, SoapUITreeNode>();

    public SoapUITreeModel(Workspace workspace) {
        this.workspaceNode = new WorkspaceTreeNode(workspace, this);
        this.mapModelItem(this.workspaceNode);
    }

    @Override
    public Object getRoot() {
        return this.workspaceNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        SoapUITreeNode treeNode = (SoapUITreeNode)parent;
        return treeNode.getChildNode(index);
    }

    @Override
    public int getChildCount(Object parent) {
        SoapUITreeNode treeNode = (SoapUITreeNode)parent;
        return treeNode.getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        SoapUITreeNode treeNode = (SoapUITreeNode)node;
        return treeNode.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        SoapUITreeNode treeNode = (SoapUITreeNode)path.getLastPathComponent();
        if (treeNode.valueChanged(newValue)) {
            // empty if block
        }
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        SoapUITreeNode treeNode = (SoapUITreeNode)parent;
        return treeNode.getIndexOfChild(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void mapModelItem(SoapUITreeNode soapUITreeNode) {
        this.modelItemMap.put(soapUITreeNode.getModelItem(), soapUITreeNode);
    }

    public void unmapModelItem(ModelItem modelItem) {
        if (this.modelItemMap.containsKey(modelItem)) {
            this.modelItemMap.remove(modelItem);
        } else {
            logger.error((Object)("Failed to unmap model item [" + modelItem.getName() + "]"));
        }
    }

    public void notifyNodesInserted(TreeModelEvent e) {
        Iterator<TreeModelListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().treeNodesInserted(e);
        }
    }

    public void notifyNodesRemoved(TreeModelEvent e) {
        Iterator<TreeModelListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().treeNodesRemoved(e);
        }
    }

    public void notifyStructureChanged(TreeModelEvent e) {
        Iterator<TreeModelListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().treeStructureChanged(e);
        }
    }

    public void notifyNodesChanged(TreeModelEvent e) {
        Iterator<TreeModelListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().treeNodesChanged(e);
        }
    }

    public TreePath getPath(SoapUITreeNode treeNode) {
        ArrayList<SoapUITreeNode> nodes = new ArrayList<SoapUITreeNode>();
        nodes.add(treeNode);
        for (treeNode = treeNode.getParentTreeNode(); treeNode != null; treeNode = treeNode.getParentTreeNode()) {
            nodes.add(0, treeNode);
        }
        return new TreePath(nodes.toArray());
    }

    public void notifyNodeChanged(SoapUITreeNode treeNode) {
        SoapUITreeNode parent = treeNode.getParentTreeNode();
        int ix = parent.getIndexOfChild(treeNode);
        if (ix == -1) {
            logger.error((Object)("Changed node [" + treeNode + "] not found in parent [" + parent + "]"));
            return;
        }
        this.notifyNodesChanged(new TreeModelEvent((Object)this, this.getPath(parent), new int[]{ix}, new Object[]{parent.getChildNode(ix)}));
    }

    public void notifyNodeInserted(SoapUITreeNode treeNode) {
        SoapUITreeNode parent = treeNode.getParentTreeNode();
        int ix = parent.getIndexOfChild(treeNode);
        if (ix == -1) {
            logger.error((Object)("Inserted node [" + treeNode + "] not found in parent [" + parent + "]"));
            return;
        }
        this.mapModelItem(treeNode);
        this.notifyNodesInserted(new TreeModelEvent((Object)this, this.getPath(parent), new int[]{ix}, new Object[]{parent.getChildNode(ix)}));
    }

    public void notifyNodeRemoved(SoapUITreeNode treeNode) {
        SoapUITreeNode parent = treeNode.getParentTreeNode();
        int ix = parent.getIndexOfChild(treeNode);
        if (ix == -1) {
            logger.error((Object)("Removed node [" + treeNode + "] not found in parent [" + parent + "]"));
            return;
        }
        this.unmapModelItem(treeNode.getModelItem());
        this.notifyNodesRemoved(new TreeModelEvent((Object)this, this.getPath(parent), new int[]{ix}, new Object[]{parent.getChildNode(ix)}));
        treeNode.release();
    }

    public SoapUITreeNode getTreeNode(ModelItem parentItem) {
        return this.modelItemMap.get(parentItem);
    }

    public TreePath getPath(ModelItem modelItem) {
        return this.getPath(this.modelItemMap.get(modelItem));
    }

    public void mapModelItems(List<? extends SoapUITreeNode> treeNodes) {
        for (SoapUITreeNode soapUITreeNode : treeNodes) {
            this.mapModelItem(soapUITreeNode);
        }
    }
}

