/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions;

import com.eviware.soapui.config.RequestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.NotSoapFaultAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.RequestAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.ResponseAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.SchemaComplianceAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.SimpleContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.SimpleNotContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.SoapFaultAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.SoapResponseAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.XPathContainsAssertion;
import com.eviware.soapui.support.types.StringToStringMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlAssertionRegistry {
    private static WsdlAssertionRegistry instance;
    private Map<String, Class<? extends WsdlMessageAssertion>> availableAssertions = new HashMap<String, Class<? extends WsdlMessageAssertion>>();
    private StringToStringMap assertionLabels = new StringToStringMap();
    private static final Logger log;

    public WsdlAssertionRegistry() {
        this.addAssertion("SOAP Response", "SOAP Response", SoapResponseAssertion.class);
        this.addAssertion("Schema Compliance", "Schema Compliance", SchemaComplianceAssertion.class);
        this.addAssertion("Simple Contains", "Contains", SimpleContainsAssertion.class);
        this.addAssertion("Simple NotContains", "Not Contains", SimpleNotContainsAssertion.class);
        this.addAssertion("XPath Match", "XPath Match", XPathContainsAssertion.class);
        this.addAssertion("SOAP Fault Assertion", "Not SOAP Fault", NotSoapFaultAssertion.class);
        this.addAssertion("Not SOAP Fault Assertion", "SOAP Fault", SoapFaultAssertion.class);
    }

    public void addAssertion(String id, String label, Class<? extends WsdlMessageAssertion> assertionClass) {
        this.availableAssertions.put(id, assertionClass);
        this.assertionLabels.put(label, id);
    }

    public static synchronized WsdlAssertionRegistry getInstance() {
        if (instance == null) {
            instance = new WsdlAssertionRegistry();
        }
        return instance;
    }

    public WsdlMessageAssertion buildAssertion(RequestAssertionConfig config, Assertable request) {
        try {
            String type = config.getType();
            Class<? extends WsdlMessageAssertion> clazz = this.availableAssertions.get(type);
            if (clazz != null) {
                Constructor<? extends WsdlMessageAssertion> ctor = clazz.getConstructor(RequestAssertionConfig.class, Assertable.class);
                return ctor.newInstance(config, request);
            }
            log.error((Object)("Missing assertion for type [" + type + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAssertionTypeForName(String name) {
        return (String)this.assertionLabels.get(name);
    }

    public String[] getAvailableAssertionNames(AssertionType type) {
        ArrayList<String> result = new ArrayList<String>();
        for (String assertion : this.assertionLabels.keySet()) {
            switch (type) {
                case BOTH: {
                    result.add(assertion);
                    break;
                }
                case REQUEST: {
                    String assertionId = (String)this.assertionLabels.get(assertion);
                    if (!Arrays.asList(this.availableAssertions.get(assertionId).getInterfaces()).contains(RequestAssertion.class)) break;
                    result.add(assertion);
                    break;
                }
                case RESPONSE: {
                    String assertionId = (String)this.assertionLabels.get(assertion);
                    if (!Arrays.asList(this.availableAssertions.get(assertionId).getInterfaces()).contains(ResponseAssertion.class)) break;
                    result.add(assertion);
                    break;
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String getAssertionNameForType(String type) {
        for (String assertion : this.assertionLabels.keySet()) {
            if (!((String)this.assertionLabels.get(assertion)).equals(type)) continue;
            return assertion;
        }
        return null;
    }

    static {
        log = Logger.getLogger(WsdlAssertionRegistry.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AssertionType {
        REQUEST,
        RESPONSE,
        BOTH;

    }
}

