/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.config.LoadTestConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.actions.ShowDesktopPanelAction;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.actions.testcase.AddNewLoadTestAction;
import com.eviware.soapui.impl.wsdl.actions.testcase.ClearTestCaseAction;
import com.eviware.soapui.impl.wsdl.actions.testcase.CloneTestCaseAction;
import com.eviware.soapui.impl.wsdl.actions.testcase.RemoveTestCaseAction;
import com.eviware.soapui.impl.wsdl.actions.testcase.RenameTestCaseAction;
import com.eviware.soapui.impl.wsdl.actions.testcase.TestCaseOptionsAction;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepRegistry;
import com.eviware.soapui.model.support.PropertiesMap;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.action.DefaultActionList;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestCase
extends AbstractWsdlModelItem<TestCaseConfig>
implements TestCase {
    private static final Logger logger = Logger.getLogger(WsdlTestCase.class);
    public static final String KEEP_SESSION_PROPERTY = WsdlTestCase.class.getName() + "@keepSession";
    public static final String FAIL_ON_ERROR_PROPERTY = WsdlTestCase.class.getName() + "@failOnError";
    public static final String FAIL_ON_ERRORS_PROPERTY = WsdlTestCase.class.getName() + "@failOnErrors";
    public static final String DISCARD_OK_RESULTS = WsdlTestCase.class.getName() + "@discardOkResults";
    private static final String SEARCH_PROPERTIES_PROPERTY = WsdlTestCase.class.getName() + "@searchProperties";
    private final WsdlTestSuite testSuite;
    private List<WsdlTestStep> testSteps = new ArrayList<WsdlTestStep>();
    private List<WsdlLoadTest> loadTests = new ArrayList<WsdlLoadTest>();
    private Set<TestRunListener> testRunListeners = new HashSet<TestRunListener>();
    private DefaultActionList createActions;

    public WsdlTestCase(WsdlTestSuite testSuite, TestCaseConfig config) {
        super(config, testSuite, "/testCase.gif");
        WsdlTestStep testStep;
        this.testSuite = testSuite;
        List testStepConfigs = config.getTestStepList();
        for (TestStepConfig tsc : testStepConfigs) {
            testStep = this.createTestStepFromConfig(tsc);
            if (testStep == null) continue;
            this.ensureUniqueName(testStep);
            this.testSteps.add(testStep);
        }
        Iterator<Object> i$ = this.testSteps.iterator();
        while (i$.hasNext()) {
            WsdlTestStep step;
            testStep = step = (WsdlTestStep)i$.next();
            testStep.postInit((TestStepConfig)testStep.getConfig());
        }
        List loadTestConfigs = config.getLoadTestList();
        for (LoadTestConfig tsc : loadTestConfigs) {
            WsdlLoadTest loadTest = new WsdlLoadTest(this, tsc);
            this.loadTests.add(loadTest);
        }
        this.addAction(new ShowDesktopPanelAction("Open TestCase Editor", "Opens the TestCase Editor for this TestCase", this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new AddNewLoadTestAction(this));
        this.addAction(new CloneTestCaseAction(this));
        this.addAction(new ClearTestCaseAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new TestCaseOptionsAction(this));
        this.createActions = new DefaultActionList("New Step");
        WsdlTestStepRegistry registry = WsdlTestStepRegistry.getInstance();
        WsdlTestStepFactory[] factories = registry.getFactories();
        for (int c = 0; c < factories.length; ++c) {
            if (!factories[c].canCreate()) continue;
            this.createActions.addAction(new AddTestStepAction(factories[c]));
        }
        this.addAction(new ActionSupport.ActionListAction(this.createActions));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new RenameTestCaseAction(this));
        this.addAction(new RemoveTestCaseAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/testcases.html"));
        if (!config.isSetFailOnError()) {
            config.setFailOnError(true);
        }
        if (!config.isSetFailTestCaseOnErrors()) {
            config.setFailTestCaseOnErrors(true);
        }
        if (!config.isSetKeepSession()) {
            config.setKeepSession(false);
        }
    }

    public boolean getKeepSession() {
        return ((TestCaseConfig)this.getConfig()).getKeepSession();
    }

    public void setKeepSession(boolean keepSession) {
        boolean old = this.getKeepSession();
        if (old != keepSession) {
            ((TestCaseConfig)this.getConfig()).setKeepSession(keepSession);
            this.notifyPropertyChanged(KEEP_SESSION_PROPERTY, old, keepSession);
        }
    }

    public boolean getFailOnError() {
        return ((TestCaseConfig)this.getConfig()).getFailOnError();
    }

    public boolean getFailTestCaseOnErrors() {
        return ((TestCaseConfig)this.getConfig()).getFailTestCaseOnErrors();
    }

    public void setFailOnError(boolean failOnError) {
        boolean old = this.getFailOnError();
        if (old != failOnError) {
            ((TestCaseConfig)this.getConfig()).setFailOnError(failOnError);
            this.notifyPropertyChanged(FAIL_ON_ERROR_PROPERTY, old, failOnError);
        }
    }

    public void setFailTestCaseOnErrors(boolean failTestCaseOnErrors) {
        boolean old = this.getFailTestCaseOnErrors();
        if (old != failTestCaseOnErrors) {
            ((TestCaseConfig)this.getConfig()).setFailTestCaseOnErrors(failTestCaseOnErrors);
            this.notifyPropertyChanged(FAIL_ON_ERRORS_PROPERTY, old, failTestCaseOnErrors);
        }
    }

    public boolean getSearchProperties() {
        return ((TestCaseConfig)this.getConfig()).getSearchProperties();
    }

    public void setSearchProperties(boolean searchProperties) {
        boolean old = this.getSearchProperties();
        if (old != searchProperties) {
            ((TestCaseConfig)this.getConfig()).setSearchProperties(searchProperties);
            this.notifyPropertyChanged(SEARCH_PROPERTIES_PROPERTY, old, searchProperties);
        }
    }

    public boolean getDiscardOkResults() {
        return ((TestCaseConfig)this.getConfig()).getDiscardOkResults();
    }

    public void setDiscardOkResults(boolean discardOkResults) {
        boolean old = this.getDiscardOkResults();
        if (old != discardOkResults) {
            ((TestCaseConfig)this.getConfig()).setDiscardOkResults(discardOkResults);
            this.notifyPropertyChanged(DISCARD_OK_RESULTS, old, discardOkResults);
        }
    }

    private WsdlTestStep createTestStepFromConfig(TestStepConfig tsc) {
        WsdlTestStepFactory factory = WsdlTestStepRegistry.getInstance().getFactory(tsc.getType());
        if (factory != null) {
            WsdlTestStep testStep = factory.buildTestStep(this, tsc);
            return testStep;
        }
        logger.error((Object)("Failed to create test step for [" + tsc.getName() + "]"));
        return null;
    }

    private boolean ensureUniqueName(WsdlTestStep testStep) {
        String name = testStep.getName();
        while (name == null || this.getTestStepByName(name) != null) {
            if (name == null) {
                name = testStep.getName();
            } else {
                int cnt = 0;
                while (this.getTestStepByName(name) != null) {
                    name = testStep.getName() + " " + ++cnt;
                }
                if (cnt == 0) break;
            }
            if ((name = UISupport.prompt("TestStep name must be unique, please specify new name for step\n[" + testStep.getName() + "] in TestCase [" + this.getTestSuite().getProject().getName() + "->" + this.getTestSuite().getName() + "->" + this.getName() + "]", "Change TestStep name", name)) != null) continue;
            return false;
        }
        if (!name.equals(testStep.getName())) {
            testStep.setName(name);
        }
        return true;
    }

    public WsdlLoadTest addNewLoadTest(String name) {
        WsdlLoadTest loadTest = new WsdlLoadTest(this, ((TestCaseConfig)this.getConfig()).addNewLoadTest());
        loadTest.setStartDelay(0);
        loadTest.setName(name);
        this.loadTests.add(loadTest);
        loadTest.addAssertion("Step Status", "- Any -", false);
        this.getTestSuite().fireLoadTestAdded(loadTest);
        return loadTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadTest(WsdlLoadTest loadTest) {
        int ix = this.loadTests.indexOf(loadTest);
        this.loadTests.remove(ix);
        try {
            this.getTestSuite().fireLoadTestRemoved(loadTest);
        }
        finally {
            loadTest.release();
            ((TestCaseConfig)this.getConfig()).removeLoadTest(ix);
        }
    }

    @Override
    public WsdlTestSuite getTestSuite() {
        return this.testSuite;
    }

    public WsdlTestStep cloneStep(WsdlTestStep testStep, String name) {
        return testStep.clone(this, name);
    }

    public TestStepResult.TestStepStatus getStatus() {
        return TestStepResult.TestStepStatus.UNKNOWN;
    }

    @Override
    public WsdlTestStep getTestStepAt(int index) {
        return this.testSteps.get(index);
    }

    @Override
    public int getTestStepCount() {
        return this.testSteps.size();
    }

    @Override
    public WsdlLoadTest getLoadTestAt(int index) {
        return this.loadTests.get(index);
    }

    @Override
    public LoadTest getLoadTestByName(String loadTestName) {
        return (LoadTest)((Object)this.getWsdlModelItemByName(this.loadTests, loadTestName));
    }

    @Override
    public int getLoadTestCount() {
        return this.loadTests.size();
    }

    public WsdlTestStep addTestStep(TestStepConfig stepConfig) {
        return this.insertTestStep(stepConfig, -1);
    }

    public WsdlTestStep addTestStep(String type, String name) {
        TestStepConfig newStepConfig = WsdlTestStepRegistry.getInstance().getFactory(type).createNewTestStep(this, name);
        if (newStepConfig != null) {
            return this.addTestStep(newStepConfig);
        }
        return null;
    }

    public WsdlTestStep insertTestStep(String type, String name, int index) {
        TestStepConfig newStepConfig = WsdlTestStepRegistry.getInstance().getFactory(type).createNewTestStep(this, name);
        if (newStepConfig != null) {
            return this.insertTestStep(newStepConfig, index);
        }
        return null;
    }

    public WsdlTestStep insertTestStep(TestStepConfig stepConfig, int ix) {
        TestStepConfig newStepConfig = ix == -1 ? ((TestCaseConfig)this.getConfig()).addNewTestStep() : ((TestCaseConfig)this.getConfig()).insertNewTestStep(ix);
        newStepConfig.set((XmlObject)stepConfig);
        WsdlTestStep testStep = this.createTestStepFromConfig(newStepConfig);
        if (!this.ensureUniqueName(testStep)) {
            return null;
        }
        if (ix == -1) {
            this.testSteps.add(testStep);
        } else {
            this.testSteps.add(ix, testStep);
        }
        testStep.postInit((TestStepConfig)testStep.getConfig());
        if (this.getTestSuite() != null) {
            this.getTestSuite().fireTestStepAdded(testStep, ix == -1 ? this.testSteps.size() - 1 : ix);
        }
        return testStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestStep(WsdlTestStep testStep) {
        int ix = this.testSteps.indexOf(testStep);
        if (ix == -1) {
            logger.error((Object)("TestStep [" + testStep.getName() + "] passed to removeTestStep in testCase [" + this.getName() + "] not found"));
            return;
        }
        this.testSteps.remove(ix);
        try {
            this.getTestSuite().fireTestStepRemoved(testStep, ix);
        }
        finally {
            testStep.release();
            for (int c = 0; c < ((TestCaseConfig)this.getConfig()).sizeOfTestStepArray(); ++c) {
                if (testStep.getConfig() != ((TestCaseConfig)this.getConfig()).getTestStepArray(c)) continue;
                ((TestCaseConfig)this.getConfig()).removeTestStep(c);
                break;
            }
        }
    }

    @Override
    public WsdlTestCaseRunner run(PropertiesMap properties, boolean async) {
        WsdlTestCaseRunner runner = new WsdlTestCaseRunner(this, properties);
        runner.start(async);
        return runner;
    }

    @Override
    public void addTestRunListener(TestRunListener listener) {
        if (listener == null) {
            throw new RuntimeException("listener must not be null");
        }
        this.testRunListeners.add(listener);
    }

    @Override
    public void removeTestRunListener(TestRunListener listener) {
        this.testRunListeners.remove(listener);
    }

    public TestRunListener[] getTestRunListeners() {
        return this.testRunListeners.toArray(new TestRunListener[this.testRunListeners.size()]);
    }

    WsdlTestStep[] getTestSteps() {
        return this.testSteps.toArray(new WsdlTestStep[this.testSteps.size()]);
    }

    @Override
    public int getIndexOfTestStep(TestStep step) {
        return this.testSteps.indexOf(step);
    }

    @Override
    public void moveTestStep(int ix, int offset) {
        int c;
        if (offset == 0) {
            return;
        }
        WsdlTestStep step = this.testSteps.get(ix);
        this.testSteps.remove(ix);
        this.testSteps.add(ix + offset, step);
        TestStepConfig[] configs = new TestStepConfig[this.testSteps.size()];
        for (c = 0; c < this.testSteps.size(); ++c) {
            if (offset > 0) {
                if (c < ix) {
                    configs[c] = (TestStepConfig)((TestCaseConfig)this.getConfig()).getTestStepArray(c).copy();
                    continue;
                }
                if (c < ix + offset) {
                    configs[c] = (TestStepConfig)((TestCaseConfig)this.getConfig()).getTestStepArray(c + 1).copy();
                    continue;
                }
                if (c == ix + offset) {
                    configs[c] = (TestStepConfig)((TestCaseConfig)this.getConfig()).getTestStepArray(ix).copy();
                    continue;
                }
                configs[c] = (TestStepConfig)((TestCaseConfig)this.getConfig()).getTestStepArray(c).copy();
                continue;
            }
            configs[c] = c < ix + offset ? (TestStepConfig)((TestCaseConfig)this.getConfig()).getTestStepArray(c).copy() : (c == ix + offset ? (TestStepConfig)((TestCaseConfig)this.getConfig()).getTestStepArray(ix).copy() : (c <= ix ? (TestStepConfig)((TestCaseConfig)this.getConfig()).getTestStepArray(c - 1).copy() : (TestStepConfig)((TestCaseConfig)this.getConfig()).getTestStepArray(c).copy()));
        }
        ((TestCaseConfig)this.getConfig()).setTestStepArray(configs);
        for (c = 0; c < configs.length; ++c) {
            this.testSteps.get(c).resetConfigOnMove(((TestCaseConfig)this.getConfig()).getTestStepArray(c));
        }
        this.getTestSuite().fireTestStepMoved(step, ix, offset);
    }

    @Override
    public int getIndexOfLoadTest(LoadTest loadTest) {
        return this.loadTests.indexOf(loadTest);
    }

    @Override
    public int getTestStepIndexByName(String stepName) {
        for (int c = 0; c < this.testSteps.size(); ++c) {
            if (!this.testSteps.get(c).getName().equals(stepName)) continue;
            return c;
        }
        return -1;
    }

    public TestStep findPreviousStepOfType(TestStep referenceStep, Class stepClass) {
        int ix;
        int currentStepIndex = this.getIndexOfTestStep(referenceStep);
        for (ix = currentStepIndex - 1; ix >= 0 && !this.getTestStepAt(ix).getClass().equals(stepClass); --ix) {
        }
        return ix < 0 ? null : this.getTestStepAt(ix);
    }

    public TestStep findNextStepOfType(TestStep referenceStep, Class stepClass) {
        int ix;
        int currentStepIndex = this.getIndexOfTestStep(referenceStep);
        for (ix = currentStepIndex + 1; ix < this.getTestStepCount() && !this.getTestStepAt(ix).getClass().equals(stepClass); ++ix) {
        }
        return ix >= this.getTestStepCount() ? null : this.getTestStepAt(ix);
    }

    @Override
    public List<TestStep> getTestStepList() {
        ArrayList<TestStep> result = new ArrayList<TestStep>();
        for (WsdlTestStep step : this.testSteps) {
            result.add(step);
        }
        return result;
    }

    public List<TestStep> getTestStepsOfType(Class<? extends WsdlTestStep> stepType) {
        ArrayList<TestStep> result = new ArrayList<TestStep>();
        for (WsdlTestStep step : this.testSteps) {
            if (!step.getClass().isAssignableFrom(stepType)) continue;
            result.add(step);
        }
        return result;
    }

    @Override
    public WsdlTestStep getTestStepByName(String stepName) {
        return (WsdlTestStep)this.getWsdlModelItemByName(this.testSteps, stepName);
    }

    public WsdlLoadTest cloneLoadTest(WsdlLoadTest loadTest, String name) {
        LoadTestConfig loadTestConfig = ((TestCaseConfig)this.getConfig()).addNewLoadTest();
        loadTestConfig.set(((LoadTestConfig)loadTest.getConfig()).copy());
        WsdlLoadTest newLoadTest = new WsdlLoadTest(this, loadTestConfig);
        newLoadTest.setName(name);
        this.loadTests.add(newLoadTest);
        this.getTestSuite().fireLoadTestAdded(newLoadTest);
        return newLoadTest;
    }

    @Override
    public void release() {
        super.release();
        for (WsdlTestStep testStep : this.testSteps) {
            testStep.release();
        }
        for (WsdlLoadTest loadTest : this.loadTests) {
            loadTest.release();
        }
    }

    public ActionList getCreateActions() {
        return this.createActions;
    }

    public class AddTestStepAction
    extends AbstractAction {
        private final WsdlTestStepFactory factory;

        public AddTestStepAction(WsdlTestStepFactory factory) {
            super(factory.getTestStepName());
            this.putValue("ShortDescription", factory.getTestStepDescription());
            this.factory = factory;
            this.putValue("SmallIcon", factory.getTestStepIcon());
        }

        public void actionPerformed(ActionEvent e) {
            TestStepConfig newTestStepConfig;
            String name = UISupport.prompt("Specify name for new step", "Add Step", this.factory.getTestStepName());
            if (name != null && (newTestStepConfig = this.factory.createNewTestStep(WsdlTestCase.this, name)) != null) {
                WsdlTestStep testStep = WsdlTestCase.this.addTestStep(newTestStepConfig);
                UISupport.selectAndShow(testStep);
            }
        }
    }
}

