/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.config.DefinitionCacheConfig;
import com.eviware.soapui.config.DefintionPartConfig;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.CachedWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaException;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.support.NullProgressDialog;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlContext {
    private String url;
    private Definition definition;
    private SchemaTypeLoader schemaTypes;
    private boolean loaded;
    private SchemaException schemaException;
    private static final Logger log = Logger.getLogger(WsdlContext.class);
    private SoapVersion soapVersion;
    private DefinitionCacheConfig cache;
    private WsdlLoader currentLoader;
    private final WsdlInterface iface;
    private WSDLFactory factory;
    private WSDLReader wsdlReader;

    public WsdlContext(String url, SoapVersion soapVersion, DefinitionCacheConfig cache, WsdlInterface iface) {
        this.url = url;
        this.soapVersion = soapVersion;
        this.cache = cache;
        this.iface = iface;
    }

    public DefinitionCacheConfig getCacheConfig() {
        return this.cache;
    }

    public Definition getDefinition() throws Exception {
        this.loadIfNecessary();
        return this.definition;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public synchronized boolean loadIfNecessary() throws Exception {
        if (!this.loaded) {
            this.load();
        }
        return this.loaded;
    }

    public synchronized void setDefinition(String url, DefinitionCacheConfig cache) {
        this.url = url;
        this.cache = null;
        this.loaded = false;
    }

    public synchronized void load() throws Exception {
        this.load(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void load(WsdlLoader wsdlLoader) throws Exception {
        if (this.loaded) {
            return;
        }
        XProgressDialog progressDialog = this.url.startsWith("file:") ? new NullProgressDialog() : UISupport.getDialogs().createProgressDialog("Loading WSDL", 3, "Loading definition..", true);
        Loader loader = new Loader(wsdlLoader);
        progressDialog.run(loader);
        if (loader.hasError()) {
            if (!(loader.getError() instanceof SchemaException)) throw loader.getError();
            this.schemaException = (SchemaException)loader.getError();
            ArrayList errorList = this.schemaException.getErrorList();
            if (errorList != null) {
                log.error((Object)("Error loading schema types from " + this.url + ", see log for details"));
                for (int c = 0; c < errorList.size(); ++c) {
                    log.error((Object)errorList.get(c).toString());
                }
            }
            UISupport.showErrorMessage("Error loading schema types from " + this.url + ", see log for details");
            return;
        } else {
            this.loaded = true;
        }
    }

    public SchemaTypeLoader getSchemaTypeLoader() throws Exception {
        this.loadIfNecessary();
        return this.schemaTypes;
    }

    public SchemaException getSchemaException() {
        return this.schemaException;
    }

    private void loadDefinitions(WsdlLoader loader) throws Exception {
        this.currentLoader = loader;
        if (this.factory == null) {
            this.factory = WSDLFactory.newInstance();
            this.wsdlReader = this.factory.newWSDLReader();
            this.wsdlReader.setFeature("javax.wsdl.verbose", true);
            this.wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        }
        this.definition = this.wsdlReader.readWSDL((WSDLLocator)loader);
        log.debug((Object)("Loaded definition: " + (this.definition != null ? "ok" : "null")));
        if (this.currentLoader.isAborted()) {
            throw new Exception("Loading of WSDL from [" + this.url + "] was aborted");
        }
        this.schemaTypes = SchemaUtils.loadSchemaTypes(this.url, this.soapVersion, loader);
    }

    public boolean validateCache(DefinitionCacheConfig cache) {
        if (cache == null) {
            return false;
        }
        if (cache.getRootPart() == null) {
            return false;
        }
        return cache.sizeOfPartArray() != 0;
    }

    public SchemaTypeSystem getSchemaTypeSystem() throws Exception {
        if (!this.loaded) {
            this.load();
        }
        if (this.schemaTypes == null) {
            return null;
        }
        return this.schemaTypes.findElement(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope")).getTypeSystem();
    }

    public boolean hasSchemaTypes() throws Exception {
        this.loadIfNecessary();
        return this.schemaTypes != null;
    }

    public SchemaType findType(QName typeName) throws Exception {
        this.loadIfNecessary();
        return this.schemaTypes == null ? null : this.schemaTypes.findType(typeName);
    }

    public String getUrl() {
        return this.url;
    }

    public Collection<String> getDefinedNamespaces() throws Exception {
        this.loadIfNecessary();
        HashSet<String> namespaces = new HashSet<String>();
        if (this.schemaTypes != null) {
            namespaces.addAll(SchemaUtils.extractNamespaces(this.getSchemaTypeSystem()));
            namespaces.remove("http://www.w3.org/2005/05/xmlmime");
            namespaces.remove("http://ws-i.org/profiles/basic/1.1/xsd");
            namespaces.remove("http://www.w3.org/2004/08/xop/include");
        }
        if (this.definition != null) {
            namespaces.add(this.definition.getTargetNamespace());
        }
        return namespaces;
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public Map<String, XmlObject> getDefinitionParts() throws Exception {
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        if (this.cache == null) {
            return SchemaUtils.getDefinitionParts(new UrlWsdlLoader(this.url));
        }
        List partList = this.cache.getPartList();
        for (DefintionPartConfig part : partList) {
            String str = part.getContent().toString();
            result.put(part.getUrl(), XmlObject.Factory.parse((String)str, (XmlOptions)new XmlOptions().setLoadLineNumbers()));
        }
        return result;
    }

    public void setDefinitionCache(DefinitionCacheConfig definitionCache) {
        this.cache = definitionCache;
    }

    private class Loader
    extends Worker.WorkerAdapter {
        private Exception error;
        private WsdlLoader wsdlLoader;

        public Loader(WsdlLoader wsdlLoader) {
            this.wsdlLoader = wsdlLoader;
        }

        private WsdlLoader getWsdlLoader() {
            if (this.wsdlLoader != null) {
                return this.wsdlLoader;
            }
            return new UrlWsdlLoader(WsdlContext.this.url);
        }

        public boolean hasError() {
            return this.error != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct(XProgressMonitor monitor) {
            try {
                if (!WsdlContext.this.validateCache(WsdlContext.this.cache)) {
                    monitor.setProgress(1, "Caching definition from url [" + WsdlContext.this.url + "]");
                    WsdlContext.this.currentLoader = this.getWsdlLoader();
                    WsdlContext.this.cache = WsdlContext.this.iface == null ? WsdlLoader.cacheWsdl(WsdlContext.this.currentLoader) : WsdlContext.this.iface.cacheDefinition(WsdlContext.this.currentLoader);
                    if (WsdlContext.this.currentLoader.isAborted()) {
                        throw new Exception("Loading of WSDL from [" + WsdlContext.this.url + "] was aborted");
                    }
                }
                monitor.setProgress(1, "Loading definition from " + (WsdlContext.this.cache == null ? "url" : "cache"));
                log.debug((Object)("Loading definition from " + (WsdlContext.this.cache == null ? "url" : "cache")));
                WsdlContext.this.loadDefinitions(WsdlContext.this.cache == null ? this.getWsdlLoader() : new CachedWsdlLoader(WsdlContext.this.cache));
                Object var2_2 = null;
                return var2_2;
            }
            catch (Exception e) {
                log.error((Object)("Loading of definition failed for [" + WsdlContext.this.url + "]; " + e));
                e.printStackTrace();
                this.error = e;
                Exception exception = e;
                return exception;
            }
            finally {
                WsdlContext.this.currentLoader = null;
            }
        }

        public Exception getError() {
            return this.error;
        }

        public boolean onCancel() {
            if (WsdlContext.this.currentLoader == null) {
                return false;
            }
            return WsdlContext.this.currentLoader.abort();
        }
    }
}

