/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.config.DefinitionCacheConfig;
import com.eviware.soapui.config.DefintionPartConfig;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.support.Tools;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpState;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedWsdlLoader
extends WsdlLoader {
    private HttpState state;
    private final DefinitionCacheConfig config;

    public CachedWsdlLoader(DefinitionCacheConfig config) {
        super(config.getRootPart());
        this.config = config;
    }

    public CachedWsdlLoader(String wsdlUrl) throws Exception {
        this(WsdlLoader.cacheWsdl(new UrlWsdlLoader(wsdlUrl)));
    }

    @Override
    public InputStream load(String url) throws Exception {
        XmlObject xmlObject = this.loadXmlObject(url, null);
        return xmlObject == null ? null : xmlObject.newInputStream();
    }

    @Override
    public XmlObject loadXmlObject(String url, XmlOptions options) throws Exception {
        List partList = this.config.getPartList();
        for (DefintionPartConfig part : partList) {
            if (!part.getUrl().equalsIgnoreCase(url)) continue;
            return XmlObject.Factory.parse((String)part.getContent().toString(), (XmlOptions)new XmlOptions().setLoadLineNumbers());
        }
        return null;
    }

    @Override
    public boolean abort() {
        return false;
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    public String saveDefinition(String folderName) throws Exception {
        File outFolder = new File(folderName);
        if (!outFolder.exists() && !outFolder.mkdirs()) {
            throw new Exception("Failed to create directory [" + folderName + "]");
        }
        HashMap<String, String> urlToFileMap = new HashMap<String, String>();
        this.setFilenameForUrl(this.config.getRootPart(), "http://schemas.xmlsoap.org/wsdl/", urlToFileMap);
        List partList = this.config.getPartList();
        for (DefintionPartConfig part : partList) {
            this.setFilenameForUrl(part.getUrl(), part.getType(), urlToFileMap);
        }
        for (DefintionPartConfig part : partList) {
            XmlObject obj = XmlObject.Factory.parse((String)part.getContent().toString());
            this.replaceImportsAndIncludes(obj, urlToFileMap, part.getUrl());
            obj.save(new File(outFolder, (String)urlToFileMap.get(part.getUrl())));
        }
        return folderName + File.separatorChar + (String)urlToFileMap.get(this.config.getRootPart());
    }

    private void setFilenameForUrl(String fileUrl, String type, Map<String, String> urlToFileMap) throws MalformedURLException {
        URL url = new URL(fileUrl);
        String path = url.getPath();
        int ix = path.lastIndexOf(47);
        String fileName = ix == -1 ? path : path.substring(ix + 1);
        ix = fileName.lastIndexOf(46);
        if (ix != -1) {
            fileName = fileName.substring(0, ix);
        }
        fileName = type.equals("http://schemas.xmlsoap.org/wsdl/") ? fileName + ".wsdl" : (type.equals("http://www.w3.org/2001/XMLSchema") ? fileName + ".xsd" : fileName + ".xml");
        while (urlToFileMap.containsValue(fileName)) {
            ix = fileName.lastIndexOf(46);
            fileName = fileName.substring(0, ix) + "_" + fileName.substring(ix);
        }
        urlToFileMap.put(fileUrl, fileName);
    }

    private void replaceImportsAndIncludes(XmlObject xmlObject, Map<String, String> urlToFileMap, String baseUrl) throws Exception {
        XmlObject[] wsdlImports = xmlObject.selectPath("declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import/@location");
        for (int i = 0; i < wsdlImports.length; ++i) {
            SimpleValue wsdlImport = (SimpleValue)wsdlImports[i];
            this.replaceLocation(urlToFileMap, baseUrl, wsdlImport);
        }
        XmlObject[] schemaImports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
        for (int i = 0; i < schemaImports.length; ++i) {
            SimpleValue schemaImport = (SimpleValue)schemaImports[i];
            this.replaceLocation(urlToFileMap, baseUrl, schemaImport);
        }
        XmlObject[] schemaIncludes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
        for (int i = 0; i < schemaIncludes.length; ++i) {
            SimpleValue schemaInclude = (SimpleValue)schemaIncludes[i];
            this.replaceLocation(urlToFileMap, baseUrl, schemaInclude);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceLocation(Map<String, String> urlToFileMap, String baseUrl, SimpleValue wsdlImport) throws Exception {
        String location = wsdlImport.getStringValue();
        if (location == null) return;
        if (location.startsWith("file:") || location.indexOf("://") > 0) {
            String newLocation = urlToFileMap.get(location);
            if (newLocation == null) throw new Exception("Missing local file for [" + newLocation + "]");
            wsdlImport.setStringValue(newLocation);
            return;
        } else {
            String loc = Tools.joinRelativeUrl(baseUrl, location);
            String newLocation = urlToFileMap.get(loc);
            if (newLocation == null) throw new Exception("Missing local file for [" + loc + "]");
            wsdlImport.setStringValue(newLocation);
        }
    }

    public void close() {
    }
}

