/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class ProxyUtils {
    public static HostConfiguration initProxySettings(Settings settings, HttpState httpState, HostConfiguration hostConfiguration, String urlString) {
        if (hostConfiguration == null) {
            hostConfiguration = new HostConfiguration();
        }
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost == null) {
            proxyHost = settings.getString(ProxySettings.HOST, null);
        }
        if (proxyPort == null) {
            proxyPort = settings.getString(ProxySettings.PORT, null);
        }
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null && proxyPort.length() > 0) {
            String[] excludes = settings.getString(ProxySettings.EXCLUDES, "").split(",");
            try {
                URL url = new URL(urlString);
                if (!ProxyUtils.excludes(excludes, url.getHost(), url.getPort())) {
                    hostConfiguration.setProxy(proxyHost, Integer.parseInt(proxyPort));
                    String proxyUsername = settings.getString(ProxySettings.USERNAME, null);
                    String proxyPassword = settings.getString(ProxySettings.PASSWORD, null);
                    if (proxyUsername != null && proxyPassword != null) {
                        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                        httpState.setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds);
                    }
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return hostConfiguration;
    }

    public static boolean excludes(String[] excludes, String proxyHost, int proxyPort) {
        for (int c = 0; c < excludes.length; ++c) {
            String exclude = excludes[c].trim();
            if (exclude.length() == 0) continue;
            int ix = exclude.indexOf(58);
            if (ix >= 0 && exclude.length() > ix + 1) {
                String excludePort = exclude.substring(ix + 1);
                if (proxyPort == -1 || !excludePort.equals(String.valueOf(proxyPort))) continue;
                exclude = exclude.substring(0, ix);
            }
            if (!proxyHost.endsWith(exclude)) continue;
            return true;
        }
        return false;
    }
}

