/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.support.Tools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;

public final class TimeablePostMethod
extends PostMethod {
    private long timeTaken;
    private long startTime;
    private long maxSize;
    private byte[] responseBody;
    private SSLInfo sslInfo;

    protected void readResponse(HttpState arg0, HttpConnection arg1) throws IOException, HttpException {
        super.readResponse(arg0, arg1);
        this.timeTaken = this.getTimeTakenUntilNow();
        Socket socket = arg1.getSocket();
        if (socket instanceof SSLSocket) {
            this.sslInfo = new SSLInfo((SSLSocket)socket);
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getTimeTakenUntilNow() {
        long nanoTime = System.nanoTime();
        long result = (nanoTime - this.startTime + 500000L) / 1000000L;
        if (result == 0L) {
            System.out.println("time taken = 0 ms; " + (nanoTime - this.startTime) + " ns");
            result = 1L;
        }
        return result;
    }

    protected void writeRequest(HttpState arg0, HttpConnection arg1) throws IOException, HttpException {
        super.writeRequest(arg0, arg1);
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
    }

    public void initStartTime() {
        this.startTime = System.nanoTime();
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public byte[] getResponseBody() throws IOException {
        if (this.responseBody != null) {
            return this.responseBody;
        }
        long contentLength = this.getResponseContentLength();
        if (this.maxSize == 0L || contentLength >= 0L && contentLength <= this.maxSize) {
            return super.getResponseBody();
        }
        InputStream instream = this.getResponseBodyAsStream();
        ByteArrayOutputStream outstream = Tools.readAll(instream, this.maxSize);
        this.responseBody = outstream.toByteArray();
        if (HttpClientSupport.isZippedResponse((HttpMethodBase)this)) {
            this.responseBody = HttpClientSupport.decompress(this.responseBody);
        }
        return this.responseBody;
    }

    public SSLInfo getSSLInfo() {
        return this.sslInfo;
    }
}

