/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.transports.http.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BodyPartAttachment;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BodyPartDataSource;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MultipartMessageSupport {
    private final List<Attachment> attachments = new ArrayList<Attachment>();
    private Attachment rootPart;
    private MimeMessage message;
    private String responseContent;

    public MultipartMessageSupport(DataSource dataSource, String rootPartId) throws MessagingException {
        MimeMultipart mp = new MimeMultipart(dataSource);
        this.message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
        this.message.setContent((Multipart)mp);
        for (int c = 0; c < mp.getCount(); ++c) {
            BodyPart bodyPart = mp.getBodyPart(c);
            if (bodyPart.getContentType().toUpperCase().startsWith("MULTIPART/")) {
                MimeMultipart mp2 = new MimeMultipart((DataSource)new BodyPartDataSource(bodyPart));
                for (int i = 0; i < mp2.getCount(); ++i) {
                    this.attachments.add(new BodyPartAttachment(mp2.getBodyPart(i)));
                }
                continue;
            }
            BodyPartAttachment attachment = new BodyPartAttachment(bodyPart);
            String[] contentIdHeaders = bodyPart.getHeader("Content-ID");
            if (contentIdHeaders != null && contentIdHeaders.length > 0 && contentIdHeaders[0].equals(rootPartId)) {
                this.rootPart = attachment;
                continue;
            }
            this.attachments.add(attachment);
        }
        if (this.rootPart == null) {
            this.rootPart = this.attachments.remove(0);
        }
    }

    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[this.attachments.size()]);
    }

    public Attachment getRootPart() {
        return this.rootPart;
    }

    public Attachment[] getAttachmentsForPart(String partName) {
        ArrayList<Attachment> results = new ArrayList<Attachment>();
        for (Attachment attachment : this.attachments) {
            if (!attachment.getPart().equals(partName)) continue;
            results.add(attachment);
        }
        return results.toArray(new Attachment[results.size()]);
    }

    public String getContentAsString() {
        if (this.rootPart == null) {
            return null;
        }
        if (this.responseContent == null) {
            try {
                InputStream in = this.rootPart.getInputStream();
                ByteArrayOutputStream data = Tools.readAll(in, 0L);
                String contentType = this.rootPart.getContentType();
                if (contentType != null && contentType.indexOf("charset=") > 0) {
                    try {
                        int ix = contentType.indexOf("charset=");
                        int ix2 = contentType.indexOf(";", ix);
                        String charset = ix2 == -1 ? contentType.substring(ix + 8) : contentType.substring(ix + 8, ix2);
                        this.responseContent = data.toString(StringUtils.unquote(charset));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (this.responseContent == null) {
                    this.responseContent = data.toString();
                }
                if (SoapUI.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES)) {
                    this.responseContent = XmlUtils.prettyPrintXml(this.responseContent);
                }
                return this.responseContent;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public Attachment getAttachmentWithContentId(String contentId) {
        for (Attachment attachment : this.attachments) {
            if (!contentId.equals(attachment.getContentID())) continue;
            return attachment;
        }
        return null;
    }
}

