/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request.components.editor;

import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlDocument;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlEditorView;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlInspector;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlLocation;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlLocationListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.VTextIcon;
import com.eviware.soapui.support.components.VerticalTabbedPaneUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEditor
extends JPanel
implements PropertyChangeListener,
XmlLocationListener {
    private static final float DEFAULT_DIVIDER_LOCATION = 0.7f;
    private JTabbedPane inputTabs;
    private List<XmlEditorView> views = new ArrayList<XmlEditorView>();
    private XmlEditorView currentView;
    private XmlDocument xmlDocument;
    private List<XmlInspector> inspectors = new ArrayList<XmlInspector>();
    protected JSplitPane mainSplit;
    private JXToolBar inspectToolbar;
    private Map<XmlInspector, JToggleButton> inspectorButtons = new HashMap<XmlInspector, JToggleButton>();
    private XmlInspector currentInspector;
    private JPanel inspectorPanel;
    private int lastDividerLocation = 0;

    public XmlEditor(XmlDocument xmlDocument) {
        super(new BorderLayout());
        this.xmlDocument = xmlDocument;
        this.setBackground(Color.LIGHT_GRAY);
        this.inputTabs = new JTabbedPane(2, 1);
        this.inputTabs.setUI(new VerticalTabbedPaneUI());
        this.inputTabs.setFont(this.inputTabs.getFont().deriveFont(8));
        this.inputTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int currentViewIndex = XmlEditor.this.views.indexOf(XmlEditor.this.currentView);
                if (XmlEditor.this.currentView != null) {
                    if (XmlEditor.this.inputTabs.getSelectedIndex() == currentViewIndex) {
                        return;
                    }
                    if (!XmlEditor.this.currentView.deactivate()) {
                        XmlEditor.this.inputTabs.setSelectedIndex(currentViewIndex);
                        return;
                    }
                }
                XmlEditorView previousView = XmlEditor.this.currentView;
                int selectedIndex = XmlEditor.this.inputTabs.getSelectedIndex();
                if (selectedIndex == -1) {
                    XmlEditor.this.currentView = null;
                    return;
                }
                XmlEditor.this.currentView = (XmlEditorView)XmlEditor.this.views.get(selectedIndex);
                if (XmlEditor.this.currentView != null && !XmlEditor.this.currentView.activate(previousView == null ? null : previousView.getLocation())) {
                    XmlEditor.this.inputTabs.setSelectedIndex(currentViewIndex);
                    if (currentViewIndex == -1) {
                        return;
                    }
                }
                if (!XmlEditor.this.currentView.isInspectable() && XmlEditor.this.currentInspector != null) {
                    XmlEditor.this.lastDividerLocation = XmlEditor.this.mainSplit.getDividerLocation();
                }
                XmlEditor.this.inspectorPanel.setVisible(XmlEditor.this.currentView.isInspectable() && XmlEditor.this.currentInspector != null);
                XmlEditor.this.inspectToolbar.setVisible(XmlEditor.this.currentView.isInspectable());
                if (XmlEditor.this.currentView.isInspectable() && XmlEditor.this.currentInspector != null) {
                    if (XmlEditor.this.lastDividerLocation == 0) {
                        XmlEditor.this.mainSplit.setDividerLocation(0.7f);
                    } else {
                        XmlEditor.this.mainSplit.setDividerLocation(XmlEditor.this.lastDividerLocation);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (XmlEditor.this.currentView != null) {
                            XmlEditor.this.currentView.getComponent().requestFocus();
                        }
                    }
                });
            }
        });
        this.inspectorPanel = new JPanel(new CardLayout());
        this.inspectorPanel.setVisible(false);
        this.mainSplit = new JSplitPane(0, this.inputTabs, this.inspectorPanel);
        this.mainSplit.setDividerSize(10);
        this.mainSplit.setBorder(null);
        this.mainSplit.setOneTouchExpandable(false);
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)this.createInspectButtons(), "Last");
        this.mainSplit.setResizeWeight(0.8);
    }

    private JComponent createInspectButtons() {
        this.inspectToolbar = UISupport.createToolbar();
        this.inspectToolbar.addSpace(10);
        this.inspectToolbar.setBackground(Color.WHITE);
        this.inspectToolbar.setOpaque(true);
        return this.inspectToolbar;
    }

    public void addInspector(XmlInspector inspector) {
        if (this.inspectors.size() > 0) {
            this.inspectToolbar.addSeparator();
        }
        this.inspectors.add(inspector);
        this.inspectorPanel.add((Component)inspector.getComponent(), inspector.getClass().getName());
        JToggleButton button = new JToggleButton(new SelectInspectorAction(inspector));
        button.setToolTipText(inspector.getDescription());
        button.setOpaque(true);
        this.inspectorButtons.put(inspector, button);
        this.inspectToolbar.add(button);
        this.inspectToolbar.addRelatedGap();
    }

    public void addEditorView(XmlEditorView editorView) {
        this.views.add(editorView);
        this.inputTabs.addTab(null, new VTextIcon(this.inputTabs, editorView.getTitle(), 2), editorView.getComponent());
        editorView.addPropertyChangeListener(XmlEditorView.TITLE_PROPERTY, this);
        editorView.addLocationListener(this);
        editorView.setXmlDocument(this.xmlDocument);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int ix = this.views.indexOf(evt.getSource());
        if (ix == -1) {
            return;
        }
        this.inputTabs.setTitleAt(ix, (String)evt.getNewValue());
    }

    public void selectView(int viewIndex) {
        this.inputTabs.setSelectedIndex(viewIndex);
    }

    @Override
    public void requestFocus() {
        if (this.currentView != null) {
            this.currentView.getComponent().requestFocus();
        }
    }

    public final XmlDocument getXmlDocument() {
        return this.xmlDocument;
    }

    public boolean saveDocument(boolean validate) {
        return this.currentView == null ? true : this.currentView.saveDocument(validate);
    }

    @Override
    public boolean hasFocus() {
        return this.currentView == null ? false : this.currentView.getComponent().hasFocus();
    }

    public final void setXmlDocument(XmlDocument xmlDocument) {
        this.xmlDocument = xmlDocument;
        for (XmlEditorView view : this.views) {
            view.setXmlDocument(xmlDocument);
        }
    }

    public final XmlEditorView getCurrentView() {
        return this.currentView;
    }

    public final JTabbedPane getInputTabs() {
        return this.inputTabs;
    }

    public final List<XmlEditorView> getViews() {
        return this.views;
    }

    public XmlEditorView getView(String viewId) {
        for (XmlEditorView view : this.views) {
            if (!view.getViewId().equals(viewId)) continue;
            return view;
        }
        return null;
    }

    public XmlInspector getInspector(String inspectorId) {
        for (XmlInspector inspector : this.inspectors) {
            if (!inspector.getInspectorId().equals(inspectorId)) continue;
            return inspector;
        }
        return null;
    }

    @Override
    public void locationChanged(XmlLocation location) {
        if (location != null) {
            for (XmlInspector inspector : this.inspectors) {
                inspector.locationChanged(location);
            }
        }
    }

    public void setEditable(boolean enabled) {
        for (XmlEditorView view : this.views) {
            view.setEditable(enabled);
        }
    }

    public class SelectInspectorAction
    extends AbstractAction
    implements PropertyChangeListener {
        private final XmlInspector inspector;

        public SelectInspectorAction(XmlInspector inspector) {
            super(inspector.getTitle());
            this.inspector = inspector;
            inspector.addPropertyChangeListener(this);
        }

        public void actionPerformed(ActionEvent arg0) {
            JToggleButton button = (JToggleButton)XmlEditor.this.inspectorButtons.get(this.inspector);
            if (!button.isSelected()) {
                XmlEditor.this.currentInspector = null;
                button.setBackground(XmlEditor.this.inspectToolbar.getBackground());
                XmlEditor.this.lastDividerLocation = XmlEditor.this.mainSplit.getDividerLocation();
                XmlEditor.this.inspectorPanel.setVisible(false);
            } else {
                if (XmlEditor.this.currentInspector != null) {
                    ((JToggleButton)XmlEditor.this.inspectorButtons.get(XmlEditor.this.currentInspector)).setSelected(false);
                }
                XmlEditor.this.currentInspector = this.inspector;
                button.setBackground(Color.WHITE);
                if (!XmlEditor.this.inspectorPanel.isVisible()) {
                    XmlEditor.this.inspectorPanel.setVisible(true);
                    if (XmlEditor.this.lastDividerLocation == 0) {
                        XmlEditor.this.mainSplit.setDividerLocation(0.7f);
                    } else {
                        XmlEditor.this.mainSplit.setDividerLocation(XmlEditor.this.lastDividerLocation);
                    }
                }
                CardLayout cards = (CardLayout)XmlEditor.this.inspectorPanel.getLayout();
                cards.show(XmlEditor.this.inspectorPanel, this.inspector.getClass().getName());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(XmlInspector.TITLE_PROPERTY)) {
                this.putValue("Name", evt.getNewValue());
            } else if (evt.getPropertyName().equals(XmlInspector.DESCRIPTION_PROPERTY)) {
                this.putValue("ShortDescription", evt.getNewValue());
            } else if (evt.getPropertyName().equals(XmlInspector.ENABLED_PROPERTY)) {
                boolean enable = (Boolean)evt.getNewValue();
                this.setEnabled(enable);
                if (!enable && XmlEditor.this.currentInspector == this.inspector) {
                    ((JToggleButton)XmlEditor.this.inspectorButtons.get(XmlEditor.this.currentInspector)).setSelected(false);
                }
            }
        }
    }
}

