/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.loadtest;

import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportSamplesHistoryAction;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JStatisticsHistoryGraph;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StatisticsHistoryDesktopPanel
extends DefaultDesktopPanel {
    private JPanel panel;
    private final WsdlLoadTest loadTest;
    private JStatisticsHistoryGraph historyGraph;
    private JButton exportButton;
    private JComboBox selectStatisticCombo;
    private InternalPropertyChangeListener propertyChangeListener;
    private JComboBox resolutionCombo;

    public StatisticsHistoryDesktopPanel(WsdlLoadTest loadTest) {
        super("Statistics History for [" + loadTest.getName() + "]", null, null);
        this.loadTest = loadTest;
        this.propertyChangeListener = new InternalPropertyChangeListener();
        loadTest.addPropertyChangeListener(WsdlLoadTest.NAME_PROPERTY, this.propertyChangeListener);
        this.buildUI();
    }

    private void buildUI() {
        this.historyGraph = new JStatisticsHistoryGraph(this.loadTest);
        JScrollPane scrollPane = new JScrollPane(this.historyGraph);
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.panel = UISupport.buildPanelWithToolbarAndStatusBar(this.buildToolbar(), scrollPane, this.historyGraph.getLegend());
        this.panel.setPreferredSize(new Dimension(600, 400));
    }

    private JComponent buildToolbar() {
        this.exportButton = UISupport.createToolbarButton(new ExportSamplesHistoryAction(this.historyGraph));
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(5);
        toolbar.addLabeledFixed("Select Statistic:", this.buildSelectStatisticCombo());
        toolbar.addUnrelatedGap();
        toolbar.addLabeledFixed("Resolution:", this.buildResolutionCombo());
        toolbar.addGlue();
        toolbar.addFixed(this.exportButton);
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/loadtest/diagrams.html#The_Statistics_Diagram")));
        return toolbar;
    }

    private JComponent buildResolutionCombo() {
        this.resolutionCombo = new JComboBox<String>(new String[]{"data", "250", "500", "1000"});
        this.resolutionCombo.setEditable(true);
        this.resolutionCombo.setToolTipText("Sets update interval of graph in milliseconds");
        long resolution = this.historyGraph.getResolution();
        this.resolutionCombo.setSelectedItem(resolution == 0L ? "data" : String.valueOf(resolution));
        this.resolutionCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    long resolution;
                    String value = StatisticsHistoryDesktopPanel.this.resolutionCombo.getSelectedItem().toString();
                    long l = resolution = value.equals("data") ? 0L : Long.parseLong(value);
                    if (resolution != StatisticsHistoryDesktopPanel.this.historyGraph.getResolution()) {
                        StatisticsHistoryDesktopPanel.this.historyGraph.setResolution(resolution);
                    }
                }
                catch (Exception ex) {
                    long resolution = StatisticsHistoryDesktopPanel.this.historyGraph.getResolution();
                    StatisticsHistoryDesktopPanel.this.resolutionCombo.setSelectedItem(resolution == 0L ? "data" : String.valueOf(resolution));
                }
            }
        });
        return this.resolutionCombo;
    }

    private JComponent buildSelectStatisticCombo() {
        DefaultComboBoxModel<LoadTestStatistics.Statistic> model = new DefaultComboBoxModel<LoadTestStatistics.Statistic>();
        model.addElement(LoadTestStatistics.Statistic.AVERAGE);
        model.addElement(LoadTestStatistics.Statistic.TPS);
        model.addElement(LoadTestStatistics.Statistic.ERRORS);
        model.addElement(LoadTestStatistics.Statistic.BPS);
        this.selectStatisticCombo = new JComboBox(model);
        this.selectStatisticCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                StatisticsHistoryDesktopPanel.this.historyGraph.setStatistic(LoadTestStatistics.Statistic.valueOf(StatisticsHistoryDesktopPanel.this.selectStatisticCombo.getSelectedItem().toString()));
            }
        });
        return this.selectStatisticCombo;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public boolean onClose(boolean canCancel) {
        this.loadTest.removePropertyChangeListener(WsdlLoadTest.NAME_PROPERTY, this.propertyChangeListener);
        return super.onClose(canCancel);
    }

    private final class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            StatisticsHistoryDesktopPanel.this.setTitle("Statistics History for [" + StatisticsHistoryDesktopPanel.this.loadTest.getName() + "]");
        }
    }
}

