/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.HeaderConfig;
import com.eviware.soapui.config.MockResponseConfig;
import com.eviware.soapui.impl.actions.ShowDesktopPanelAction;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.AttachmentContainer;
import com.eviware.soapui.impl.wsdl.WsdlAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.actions.mockresponse.CloneMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.mockresponse.DeleteMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.mockresponse.RenameMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BodyPartAttachment;
import com.eviware.soapui.impl.wsdl.submit.transports.http.MimeMessageMockResponseEntity;
import com.eviware.soapui.impl.wsdl.submit.transports.http.MockResponseDataSource;
import com.eviware.soapui.impl.wsdl.support.FileAttachment;
import com.eviware.soapui.impl.wsdl.support.MessageXmlObject;
import com.eviware.soapui.impl.wsdl.support.MessageXmlPart;
import com.eviware.soapui.impl.wsdl.support.MockFileAttachment;
import com.eviware.soapui.impl.wsdl.support.ModelItemIconAnimator;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.types.StringToStringMap;
import groovy.lang.Binding;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockResponse
extends AbstractWsdlModelItem<MockResponseConfig>
implements MockResponse,
AttachmentContainer {
    private static final Logger log = Logger.getLogger(WsdlMockResponse.class);
    public static final String MOCKRESULT_PROPERTY = WsdlMockResponse.class.getName() + "@mockresult";
    public static final String SCRIPT_PROPERTY = WsdlMockResponse.class.getName() + "@script";
    public static final String HEADERS_PROPERTY = WsdlMockResponse.class.getName() + "@headers";
    public static final String DISABLE_MULTIPART_ATTACHMENTS = WsdlMockResponse.class.getName() + "@disable-multipart-attachments";
    protected List<FileAttachment> attachments = new ArrayList<FileAttachment>();
    private List<WsdlAttachmentPart> definedAttachmentParts;
    private ModelItemIconAnimator iconAnimator;
    private WsdlMockResult mockResult;

    public WsdlMockResponse(WsdlMockOperation operation, MockResponseConfig config) {
        super(config, operation, "/mockResponse.gif");
        for (AttachmentConfig ac : ((MockResponseConfig)this.getConfig()).getAttachmentList()) {
            this.attachments.add(new MockFileAttachment(ac, this));
        }
        if (!config.isSetEncoding()) {
            config.setEncoding("UTF-8");
        }
        this.addAction(new ShowDesktopPanelAction("Open MockResponse Editor", "Opens the MockResponse Editor for this MockResponse", this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new CloneMockResponseAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new RenameMockResponseAction(this));
        this.addAction(new DeleteMockResponseAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/responses.html"));
        this.iconAnimator = new ModelItemIconAnimator(this, "/mockResponse.gif", new String[]{"/exec_request_1.gif", "/exec_request_2.gif", "/exec_request_3.gif", "/exec_request_4.gif"});
    }

    @Override
    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[this.attachments.size()]);
    }

    public String getScript() {
        return ((MockResponseConfig)this.getConfig()).isSetScript() ? ((MockResponseConfig)this.getConfig()).getScript().getStringValue() : null;
    }

    @Override
    public String getEncoding() {
        return ((MockResponseConfig)this.getConfig()).getEncoding();
    }

    public void setEncoding(String encoding) {
        String old = this.getEncoding();
        ((MockResponseConfig)this.getConfig()).setEncoding(encoding);
        this.notifyPropertyChanged(ENCODING_PROPERTY, old, encoding);
    }

    @Override
    public String getResponseContent() {
        return ((MockResponseConfig)this.getConfig()).getResponseContent();
    }

    public void setResponseContent(String responseContent) {
        String oldContent = this.getResponseContent();
        if (!responseContent.equals(oldContent)) {
            ((MockResponseConfig)this.getConfig()).setResponseContent(responseContent);
            this.notifyPropertyChanged(RESPONSECONTENT_PROPERTY, oldContent, responseContent);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.iconAnimator.getIcon();
    }

    @Override
    public WsdlMockOperation getMockOperation() {
        return (WsdlMockOperation)this.getParent();
    }

    public WsdlMockResult execute(WsdlMockRequest request, WsdlMockResult result) throws DispatchException {
        try {
            this.iconAnimator.start();
            StringToStringMap responseHeaders = this.getResponseHeaders();
            for (String name : responseHeaders.keySet()) {
                result.addHeader(name, PropertyExpansionRequestFilter.expandProperties(request.getContext(), (String)responseHeaders.get(name)));
            }
            String responseContent = this.getResponseContent();
            String script = this.getScript();
            if (script != null && script.trim().length() > 0) {
                this.evaluateScript(request);
            }
            responseContent = PropertyExpansionRequestFilter.expandProperties(request.getContext(), responseContent);
            if (!result.isCommitted()) {
                responseContent = this.writeResponse(result, responseContent);
            }
            result.setReponseContent(responseContent);
            this.setMockResult(result);
            WsdlMockResult wsdlMockResult = this.mockResult;
            return wsdlMockResult;
        }
        catch (Throwable e) {
            throw new DispatchException(e);
        }
        finally {
            this.iconAnimator.stop();
        }
    }

    public void evaluateScript(WsdlMockRequest request) {
        String script = this.getScript();
        if (script == null || script.trim().length() == 0) {
            return;
        }
        Binding localBinding = new Binding();
        WsdlMockService mockService = this.getMockOperation().getMockService();
        WsdlMockRunner mockRunner = mockService.getMockRunner();
        WsdlMockRunContext context = mockRunner == null ? new WsdlMockRunContext(mockService, null) : mockRunner.getMockContext();
        localBinding.setVariable("context", (Object)context);
        localBinding.setVariable("mockRequest", (Object)request);
        localBinding.setVariable("mockResponse", (Object)this);
        localBinding.setVariable("log", (Object)SoapUI.ensureGroovyLog());
        Script localScript = mockService.getScriptShell().parse(script);
        localScript.setBinding(localBinding);
        localScript.run();
    }

    public void setScript(String script) {
        String oldScript = this.getScript();
        if (!script.equals(oldScript)) {
            if (!((MockResponseConfig)this.getConfig()).isSetScript()) {
                ((MockResponseConfig)this.getConfig()).addNewScript();
            }
            ((MockResponseConfig)this.getConfig()).getScript().setStringValue(script);
            this.notifyPropertyChanged(SCRIPT_PROPERTY, oldScript, script);
        }
    }

    public void setResponseHeaders(StringToStringMap headers) {
        StringToStringMap oldHeaders = this.getResponseHeaders();
        HeaderConfig[] headerConfigs = new HeaderConfig[headers.size()];
        int ix = 0;
        for (String header : headers.keySet()) {
            headerConfigs[ix] = HeaderConfig.Factory.newInstance();
            headerConfigs[ix].setName(header);
            headerConfigs[ix].setValue((String)headers.get(header));
            ++ix;
        }
        ((MockResponseConfig)this.getConfig()).setHeaderArray(headerConfigs);
        this.notifyPropertyChanged(HEADERS_PROPERTY, oldHeaders, headers);
    }

    @Override
    public StringToStringMap getResponseHeaders() {
        StringToStringMap result = new StringToStringMap();
        List headerList = ((MockResponseConfig)this.getConfig()).getHeaderList();
        for (HeaderConfig header : headerList) {
            result.put(header.getName(), header.getValue());
        }
        return result;
    }

    @Override
    public Attachment attachFile(File file, boolean cache) {
        try {
            MockFileAttachment fileAttachment = new MockFileAttachment(file, cache, this);
            this.attachments.add(fileAttachment);
            this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, null, fileAttachment);
            return fileAttachment;
        }
        catch (IOException e) {
            UISupport.showErrorMessage(e);
            return null;
        }
    }

    @Override
    public int getAttachmentCount() {
        return this.attachments.size();
    }

    @Override
    public WsdlAttachment getAttachmentAt(int index) {
        return this.attachments.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttachment(Attachment attachment) {
        int ix = this.attachments.indexOf(attachment);
        this.attachments.remove(ix);
        try {
            this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, attachment, null);
        }
        finally {
            ((MockResponseConfig)this.getConfig()).removeAttachment(ix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsdlAttachmentPart[] getDefinedAttachmentParts() {
        if (this.definedAttachmentParts == null) {
            try {
                WsdlOperation operation = this.getMockOperation().getOperation();
                if (operation == null) {
                    this.definedAttachmentParts = new ArrayList<WsdlAttachmentPart>();
                } else {
                    UISupport.setHourglassCursor();
                    this.definedAttachmentParts = AttachmentUtils.extractAttachmentParts(operation, this.getResponseContent(), true);
                }
            }
            catch (Exception e) {
                log.warn((Object)e.toString());
            }
            finally {
                UISupport.resetCursor();
            }
        }
        return this.definedAttachmentParts.toArray(new WsdlAttachmentPart[this.definedAttachmentParts.size()]);
    }

    @Override
    public WsdlAttachmentPart getAttachmentPart(String partName) {
        WsdlAttachmentPart[] parts;
        for (WsdlAttachmentPart part : parts = this.getDefinedAttachmentParts()) {
            if (!part.getName().equals(partName)) continue;
            return part;
        }
        return null;
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        ArrayList<FileAttachment> result = new ArrayList<FileAttachment>();
        for (FileAttachment attachment : this.attachments) {
            if (!attachment.getPart().equals(partName)) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    @Override
    public boolean isMtomEnabled() {
        return this.getSettings().getBoolean(WsdlSettings.ENABLE_MTOM);
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        boolean old = this.isMtomEnabled();
        this.getSettings().setBoolean(WsdlSettings.ENABLE_MTOM, mtomEnabled);
        this.definedAttachmentParts = null;
        this.notifyPropertyChanged(MTOM_NABLED_PROPERTY, old, mtomEnabled);
    }

    private String writeResponse(WsdlMockResult response, String responseContent) throws Exception {
        MimeMultipart mp = null;
        WsdlOperation operation = this.getMockOperation().getOperation();
        if (operation == null) {
            throw new Exception("Missing WsdlOperation for mock response");
        }
        SoapVersion soapVersion = operation.getInterface().getSoapVersion();
        StringToStringMap contentIds = new StringToStringMap();
        boolean isXOP = false;
        if (this.isMtomEnabled() || this.getAttachmentCount() > 0) {
            try {
                MessageXmlPart[] requestParts;
                mp = new MimeMultipart();
                MessageXmlObject requestXmlObject = new MessageXmlObject(operation, this.getResponseContent(), true);
                for (MessageXmlPart requestPart : requestParts = requestXmlObject.getMessageParts()) {
                    if (!AttachmentUtils.prepareMessagePart(this, mp, requestPart, contentIds)) continue;
                    isXOP = true;
                }
                responseContent = requestXmlObject.getMessageContent();
            }
            catch (Exception e) {
                log.warn((Object)("Failed to process inline/MTOM attachments; " + e));
            }
        }
        response.initResponse();
        if (!(isXOP || mp != null && mp.getCount() != 0 || this.getAttachmentCount() != 0)) {
            String encoding = this.getEncoding();
            byte[] content = encoding == null ? responseContent.getBytes() : responseContent.getBytes(encoding);
            response.setContentType(soapVersion.getContentTypeHttpHeader(encoding));
            response.getOutputStream().write(content);
        } else {
            if (mp == null) {
                mp = new MimeMultipart();
            }
            this.initRootPart(responseContent, mp, isXOP);
            AttachmentUtils.addMimeParts(this, mp, contentIds);
            MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
            message.setContent((Multipart)mp);
            message.saveChanges();
            MimeMessageMockResponseEntity mimeMessageRequestEntity = new MimeMessageMockResponseEntity(message, isXOP, this);
            response.addHeader("Content-Type", mimeMessageRequestEntity.getContentType());
            response.addHeader("MIME-Version", "1.0");
            mimeMessageRequestEntity.writeRequest(response.getOutputStream());
        }
        return responseContent;
    }

    private void initRootPart(String requestContent, MimeMultipart mp, boolean isXOP) throws MessagingException {
        PreencodedMimeBodyPart rootPart = new PreencodedMimeBodyPart("8bit");
        rootPart.setContentID("<rootpart@soapui.org>");
        mp.addBodyPart((BodyPart)rootPart, 0);
        DataHandler dataHandler = new DataHandler((DataSource)new MockResponseDataSource(this, requestContent, isXOP));
        rootPart.setDataHandler(dataHandler);
    }

    public Attachment addAttachment(Attachment attachment) {
        if (attachment instanceof BodyPartAttachment) {
            try {
                BodyPartAttachment att = (BodyPartAttachment)attachment;
                AttachmentConfig newConfig = ((MockResponseConfig)this.getConfig()).addNewAttachment();
                newConfig.setData(Tools.readAll(att.getInputStream(), 0L).toByteArray());
                newConfig.setContentId(att.getContentID());
                newConfig.setContentType(att.getContentType());
                newConfig.setName(att.getName());
                MockFileAttachment newAttachment = new MockFileAttachment(newConfig, this);
                this.attachments.add(newAttachment);
                return newAttachment;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (attachment instanceof FileAttachment) {
            AttachmentConfig oldConfig = ((FileAttachment)attachment).getConfig();
            AttachmentConfig newConfig = (AttachmentConfig)((MockResponseConfig)this.getConfig()).addNewAttachment().set((XmlObject)oldConfig);
            MockFileAttachment newAttachment = new MockFileAttachment(newConfig, this);
            this.attachments.add(newAttachment);
            return newAttachment;
        }
        return null;
    }

    public void setMockResult(WsdlMockResult mockResult) {
        WsdlMockResult oldResult = this.mockResult;
        this.mockResult = mockResult;
        this.notifyPropertyChanged(MOCKRESULT_PROPERTY, oldResult, mockResult);
    }

    @Override
    public WsdlMockResult getMockResult() {
        return this.mockResult;
    }

    @Override
    public boolean isMultipartEnabled() {
        return !this.getSettings().getBoolean(DISABLE_MULTIPART_ATTACHMENTS);
    }

    public void setMultipartEnabled(boolean multipartEnabled) {
        this.getSettings().setBoolean(DISABLE_MULTIPART_ATTACHMENTS, multipartEnabled);
    }
}

