/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.DispatchStyleConfig;
import com.eviware.soapui.config.MockOperationConfig;
import com.eviware.soapui.config.MockResponseConfig;
import com.eviware.soapui.impl.actions.ShowDesktopPanelAction;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.actions.mockoperation.NewMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.mockoperation.RemoveMockOperationAction;
import com.eviware.soapui.impl.wsdl.actions.mockoperation.RenameMockOperationAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.OpenRequestForMockOperationAction;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.xml.XmlUtils;
import groovy.lang.Binding;
import groovy.lang.Script;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockOperation
extends AbstractWsdlModelItem<MockOperationConfig>
implements MockOperation,
PropertyChangeListener {
    public static final String DISPATCH_STYLE_PROPERTY = WsdlMockOperation.class.getName() + "@dispatchstyle";
    public static final String DEFAULT_RESPONSE_PROPERTY = WsdlMockOperation.class.getName() + "@defaultresponse";
    public static final String DISPATCH_PATH_PROPERTY = WsdlMockOperation.class.getName() + "@dispatchpath";
    private WsdlOperation operation;
    private List<WsdlMockResponse> responses = new ArrayList<WsdlMockResponse>();
    private int currentDispatchIndex;

    public WsdlMockOperation(WsdlMockService mockService, MockOperationConfig config) {
        super(config, mockService, "/mockOperation.gif");
        WsdlInterface iface = mockService.getProject().getInterfaceByName(config.getInterface());
        this.operation = (WsdlOperation)iface.getOperationByName(config.getOperation());
        List responseConfigs = config.getResponseList();
        for (MockResponseConfig responseConfig : responseConfigs) {
            WsdlMockResponse wsdlMockResponse = new WsdlMockResponse(this, responseConfig);
            wsdlMockResponse.addPropertyChangeListener(this);
            this.responses.add(wsdlMockResponse);
        }
        this.initData(config);
        this.addActions();
    }

    private void initData(MockOperationConfig config) {
        if (!config.isSetName()) {
            config.setName(this.operation.getName());
        }
        if (!config.isSetDispatchStyle()) {
            config.setDispatchStyle(DispatchStyleConfig.SEQUENCE);
        }
        if (!config.isSetDefaultResponse() && this.responses.size() > 0) {
            this.setDefaultResponse(this.responses.get(0).getName());
        }
    }

    private void addActions() {
        this.addAction(new ShowDesktopPanelAction("Open MockOperation Editor", "Opens the MockOperation Editor for this MockOperation", this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new OpenRequestForMockOperationAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new NewMockResponseAction(this));
        this.addAction(new RenameMockOperationAction(this));
        this.addAction(new RemoveMockOperationAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/operations.html"));
    }

    public WsdlMockOperation(WsdlMockService mockService, MockOperationConfig config, WsdlOperation operation) {
        super(config, mockService, "/mockOperation.gif");
        this.operation = operation;
        config.setInterface(operation.getInterface().getName());
        config.setOperation(operation.getName());
        this.initData(config);
        this.addActions();
    }

    @Override
    public WsdlMockService getMockService() {
        return (WsdlMockService)this.getParent();
    }

    @Override
    public WsdlMockResponse getMockResponseAt(int index) {
        return this.responses.get(index);
    }

    @Override
    public WsdlOperation getOperation() {
        return this.operation;
    }

    @Override
    public WsdlMockResponse getMockResponseByName(String name) {
        return (WsdlMockResponse)this.getWsdlModelItemByName(this.responses, name);
    }

    @Override
    public int getMockResponseCount() {
        return this.responses.size();
    }

    public WsdlMockResponse addNewMockResponse(MockResponseConfig responseConfig) {
        WsdlMockResponse mockResponse = new WsdlMockResponse(this, responseConfig);
        this.responses.add(mockResponse);
        if (this.responses.size() == 1) {
            this.setDefaultResponse(mockResponse.getName());
        }
        this.getMockService().fireMockResponseAdded(mockResponse);
        return mockResponse;
    }

    public WsdlMockResponse addNewMockResponse(String name, boolean createResponse) {
        MockResponseConfig responseConfig = ((MockOperationConfig)this.getConfig()).addNewResponse();
        responseConfig.setName(name);
        if (createResponse && this.getOperation() != null) {
            boolean createOptional = SoapUI.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS);
            responseConfig.setResponseContent(this.getOperation().createResponse(createOptional));
        }
        return this.addNewMockResponse(responseConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMockResponse(WsdlMockResponse mockResponse) {
        int ix = this.responses.indexOf(mockResponse);
        this.responses.remove(ix);
        mockResponse.removePropertyChangeListener(this);
        try {
            this.getMockService().fireMockResponseRemoved(mockResponse);
        }
        finally {
            mockResponse.release();
            ((MockOperationConfig)this.getConfig()).removeResponse(ix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsdlMockResult dispatchRequest(WsdlMockRequest request, HttpServletResponse response) throws DispatchException {
        try {
            WsdlMockResult result = new WsdlMockResult(request, response);
            if (this.getMockResponseCount() == 0) {
                throw new DispatchException("Missing MockResponse(s) in MockOperation [" + this.getName() + "]");
            }
            if (this.getDispatchStyle() == DispatchStyleConfig.XPATH) {
                XmlObject[] items;
                for (XmlObject item : items = this.evaluateDispatchXPath(request)) {
                    WsdlMockResponse mockResponse = this.getMockResponseByName(XmlUtils.getNodeValue(item.getDomNode()));
                    if (mockResponse == null) {
                        mockResponse = this.getMockResponseByName(this.getDefaultResponse());
                    }
                    if (mockResponse == null) continue;
                    result.setMockResponse(mockResponse);
                    mockResponse.execute(request, result);
                    return result;
                }
                throw new DispatchException("Missing matching response message");
            }
            if (this.getDispatchStyle() == DispatchStyleConfig.SCRIPT) {
                WsdlMockResponse mockResponse;
                Object retVal = this.evaluateDispatchScript(request);
                WsdlMockResponse wsdlMockResponse = mockResponse = retVal == null ? this.getMockResponseByName(this.getDefaultResponse()) : this.getMockResponseByName(retVal.toString());
                if (mockResponse != null) {
                    result.setMockResponse(mockResponse);
                    mockResponse.execute(request, result);
                    return result;
                }
                throw new DispatchException("Missing matching response message [" + retVal + "]");
            }
            WsdlMockResponse mockResponse = null;
            WsdlMockOperation wsdlMockOperation = this;
            synchronized (wsdlMockOperation) {
                if (this.getDispatchStyle() == DispatchStyleConfig.RANDOM) {
                    this.currentDispatchIndex = (int)(Math.random() * (double)this.getMockResponseCount() + 0.5);
                }
                if (this.currentDispatchIndex >= this.getMockResponseCount()) {
                    this.currentDispatchIndex = 0;
                }
                mockResponse = this.getMockResponseAt(this.currentDispatchIndex);
                result.setMockResponse(mockResponse);
                ++this.currentDispatchIndex;
            }
            mockResponse.execute(request, result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DispatchException(e);
        }
    }

    @Override
    public void release() {
        super.release();
        for (WsdlMockResponse response : this.responses) {
            response.removePropertyChangeListener(this);
            response.release();
        }
    }

    public XmlObject[] evaluateDispatchXPath(WsdlMockRequest request) throws XmlException {
        XmlObject xmlObject = request.getRequestXmlObject();
        XmlObject[] items = xmlObject.selectPath(this.getDispatchPath());
        return items;
    }

    public Object evaluateDispatchScript(WsdlMockRequest request) throws DispatchException {
        String dispatchPath = this.getDispatchPath();
        if (dispatchPath == null || dispatchPath.trim().length() == 0) {
            throw new DispatchException("Dispatch Script is empty");
        }
        try {
            WsdlMockService mockService = this.getMockService();
            WsdlMockRunner mockRunner = mockService.getMockRunner();
            WsdlMockRunContext context = mockRunner == null ? new WsdlMockRunContext(mockService, null) : mockRunner.getMockContext();
            Binding localBinding = new Binding();
            localBinding.setVariable("context", (Object)context);
            localBinding.setVariable("mockRequest", (Object)request);
            localBinding.setVariable("mockOperation", (Object)this);
            localBinding.setVariable("log", (Object)SoapUI.ensureGroovyLog());
            Script localScript = this.getMockService().getScriptShell().parse(dispatchPath);
            localScript.setBinding(localBinding);
            Object retVal = localScript.run();
            return retVal;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new DispatchException("Failed to dispatch using script; " + e);
        }
    }

    public DispatchStyleConfig.Enum getDispatchStyle() {
        return ((MockOperationConfig)this.getConfig()).getDispatchStyle();
    }

    public void setDispatchStyle(DispatchStyleConfig.Enum dispatchStyle) {
        DispatchStyleConfig.Enum old = this.getDispatchStyle();
        ((MockOperationConfig)this.getConfig()).setDispatchStyle(dispatchStyle);
        this.notifyPropertyChanged(DISPATCH_STYLE_PROPERTY, old, dispatchStyle);
    }

    public String getDispatchPath() {
        return ((MockOperationConfig)this.getConfig()).getDispatchPath();
    }

    public void setDispatchPath(String dispatchPath) {
        String old = this.getDispatchPath();
        ((MockOperationConfig)this.getConfig()).setDispatchPath(dispatchPath);
        this.notifyPropertyChanged(DISPATCH_PATH_PROPERTY, old, dispatchPath);
    }

    public String getWsdlOperationName() {
        return this.operation == null ? null : this.operation.getName();
    }

    public String getDefaultResponse() {
        return ((MockOperationConfig)this.getConfig()).getDefaultResponse();
    }

    public void setDefaultResponse(String defaultResponse) {
        String old = this.getDefaultResponse();
        ((MockOperationConfig)this.getConfig()).setDefaultResponse(defaultResponse);
        this.notifyPropertyChanged(DEFAULT_RESPONSE_PROPERTY, old, defaultResponse);
    }

    @Override
    public List<MockResponse> getMockResponses() {
        return new ArrayList<MockResponse>(this.responses);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getPropertyName().equals(WsdlMockResponse.NAME_PROPERTY) && arg0.getOldValue().equals(this.getDefaultResponse())) {
            this.setDefaultResponse(arg0.getNewValue().toString());
        }
    }

    @Override
    public WsdlMockResult getLastMockResult() {
        WsdlMockResult result = null;
        for (WsdlMockResponse response : this.responses) {
            WsdlMockResult mockResult = response.getMockResult();
            if (mockResult == null || result != null && result.getTimestamp() <= mockResult.getTimestamp()) continue;
            result = mockResult;
        }
        return result;
    }

    public void setOperation(WsdlOperation operation) {
        if (operation == null) {
            ((MockOperationConfig)this.getConfig()).unsetInterface();
            ((MockOperationConfig)this.getConfig()).unsetOperation();
        } else {
            ((MockOperationConfig)this.getConfig()).setInterface(operation.getInterface().getName());
            ((MockOperationConfig)this.getConfig()).setOperation(operation.getName());
        }
        this.operation = operation;
    }
}

