/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class ViewWsdlMockResultAction
extends AbstractAction {
    private final WsdlMockResult result;
    private DefaultDesktopPanel desktopPanel;

    public ViewWsdlMockResultAction(WsdlMockResult result) {
        super("Show Results");
        this.result = result;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.result.isDiscarded()) {
                UISupport.showInfoMessage("Request has been discarded..");
            } else {
                UISupport.showDesktopPanel(this.buildFrame());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DesktopPanel buildFrame() {
        if (this.desktopPanel == null) {
            String title = "Mock Result for [" + this.result.getMockResponse().getName() + "]";
            this.desktopPanel = new DefaultDesktopPanel(title, title, this.buildContent());
        }
        return this.desktopPanel;
    }

    private JComponent buildContent() {
        JTabbedPane messageTabs = new JTabbedPane();
        messageTabs.addTab("Request", this.buildRequestTab());
        messageTabs.addTab("Response", this.buildResponseTab());
        messageTabs.setPreferredSize(new Dimension(500, 400));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)UISupport.createTabPanel(messageTabs, true), "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("Mock Request handled at " + new Date(this.result.getTimestamp()) + ", time taken: " + this.result.getTimeTaken() + "ms"));
        builder.addGlue();
        builder.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)builder.getPanel(), "First");
        return panel;
    }

    private Component buildResponseTab() {
        JXEditTextArea resultArea = JXEditTextArea.createXmlEditor();
        resultArea.setText(XmlUtils.prettyPrintXml(this.result.getResponseContent()));
        resultArea.setEditable(false);
        resultArea.setToolTipText("Response Content");
        JScrollPane scrollPane = new JScrollPane(resultArea);
        JSplitPane split = UISupport.createVerticalSplit(new JScrollPane(new JTable(new StringToStringMapTableModel(this.result.getResponseHeaders(), "Header", "Value", false))), scrollPane);
        split.setDividerLocation(150);
        return split;
    }

    private Component buildRequestTab() {
        JXEditTextArea resultArea = JXEditTextArea.createXmlEditor();
        resultArea.setText(XmlUtils.prettyPrintXml(this.result.getMockRequest().getRequestContent()));
        resultArea.setEditable(false);
        resultArea.setToolTipText("Request Content");
        JScrollPane scrollPane = new JScrollPane(resultArea);
        JSplitPane split = UISupport.createVerticalSplit(new JScrollPane(new JTable(new StringToStringMapTableModel(this.result.getMockRequest().getRequestHeaders(), "Header", "Value", false))), scrollPane);
        split.setDividerLocation(150);
        return split;
    }
}

