/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.data;

import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplesModel
extends AbstractTableModel {
    private final LoadTest loadTest;
    private List<TestSample[]> samples = new ArrayList<TestSample[]>();
    private InternalTestRunListener testRunListener;
    private InternalTestSuiteListener testSuiteListener;
    private InternalPropertyChangeListener propertyChangeListener;
    private TestCase testCase;
    private static final Logger log = Logger.getLogger(SamplesModel.class);

    public SamplesModel(LoadTest loadTest) {
        this.loadTest = loadTest;
        this.testRunListener = new InternalTestRunListener();
        this.testSuiteListener = new InternalTestSuiteListener();
        this.propertyChangeListener = new InternalPropertyChangeListener();
        this.testCase = loadTest.getTestCase();
        loadTest.addLoadTestRunListener(this.testRunListener);
        this.testCase.getTestSuite().addTestSuiteListener(this.testSuiteListener);
        for (TestStep testStep : this.testCase.getTestStepList()) {
            testStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this.propertyChangeListener);
        }
    }

    @Override
    public int getRowCount() {
        return this.samples.size();
    }

    @Override
    public int getColumnCount() {
        return this.testCase.getTestStepCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TestSample[] testSamples = this.samples.get(rowIndex);
        return testSamples == null ? "discarded" : testSamples[columnIndex];
    }

    public void addSamples(TestSample[] newSamples) {
        if (newSamples.length != this.getColumnCount()) {
            throw new RuntimeException("Invalid number of samples reported: " + newSamples.length + ", expected " + this.getColumnCount());
        }
        this.samples.add(newSamples);
        this.fireTableRowsInserted(this.samples.size() - 1, this.samples.size() - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return TestSample.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.testCase.getTestStepAt(column).getName();
    }

    public void clear() {
        int size = this.samples.size();
        if (size > 0) {
            this.samples.clear();
            this.fireTableRowsDeleted(0, size);
        }
    }

    public List<TestSample[]> getSamples() {
        return this.samples;
    }

    public void release() {
        this.loadTest.removeLoadTestRunListener(this.testRunListener);
        this.loadTest.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
        for (TestStep testStep : this.loadTest.getTestCase().getTestStepList()) {
            testStep.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SamplesModel.this.fireTableStructureChanged();
        }
    }

    private class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepAdded(TestStep testStep, int index) {
            if (testStep.getTestCase() == SamplesModel.this.testCase) {
                testStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, SamplesModel.this.propertyChangeListener);
                for (int i = 0; i < SamplesModel.this.samples.size(); ++i) {
                    TestSample[] testSamples = (TestSample[])SamplesModel.this.samples.get(i);
                    TestSample[] newSamples = new TestSample[testSamples.length + 1];
                    for (int c = 0; c < testSamples.length; ++c) {
                        if (c < index) {
                            newSamples[c] = testSamples[c];
                            continue;
                        }
                        newSamples[c + 1] = testSamples[c];
                    }
                    SamplesModel.this.samples.set(i, newSamples);
                }
                SamplesModel.this.fireTableStructureChanged();
            }
        }

        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == SamplesModel.this.testCase) {
                testStep.removePropertyChangeListener(SamplesModel.this.propertyChangeListener);
                for (int i = 0; i < SamplesModel.this.samples.size(); ++i) {
                    TestSample[] testSamples = (TestSample[])SamplesModel.this.samples.get(i);
                    TestSample[] newSamples = new TestSample[testSamples.length - 1];
                    for (int c = 0; c < testSamples.length; ++c) {
                        if (c < index) {
                            newSamples[c] = testSamples[c];
                            continue;
                        }
                        if (c <= index) continue;
                        newSamples[c - 1] = testSamples[c];
                    }
                    SamplesModel.this.samples.set(i, newSamples);
                }
                SamplesModel.this.fireTableStructureChanged();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TestSample {
        private final TestStep testStep;
        private List<TestStepResult> results;

        public TestSample(TestStep testStep) {
            this.testStep = testStep;
        }

        public void addTestStepResult(TestStepResult result) {
            if (result.getTestStep() != this.testStep) {
                throw new RuntimeException("Trying to add sample for false testStep [" + result.getTestStep().getName() + "], " + "expecting [" + this.testStep.getName() + "]");
            }
            if (this.results == null) {
                this.results = new ArrayList<TestStepResult>();
            }
            this.results.add(result);
        }

        public List<TestStepResult> getResults() {
            return this.results;
        }

        public int getResultCount() {
            return this.results == null ? 0 : this.results.size();
        }

        public long getResultAverage() {
            if (this.results == null) {
                return 0L;
            }
            if (this.results.size() == 1) {
                return this.results.get(0).getTimeTaken();
            }
            long sum = 0L;
            for (TestStepResult result : this.results) {
                sum += result.getTimeTaken();
            }
            return sum / (long)this.results.size();
        }
    }

    private class InternalTestRunListener
    extends LoadTestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        public void afterTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext) {
            HashMap<TestStep, TestSample> samplesMap = new HashMap<TestStep, TestSample>();
            List<TestStepResult> results = testRunner.getResults();
            for (int c = 0; c < results.size(); ++c) {
                TestStepResult result = results.get(c);
                if (result == null) {
                    log.warn((Object)("Result [" + c + "] is null in TestCase [" + SamplesModel.this.testCase.getName() + "]"));
                    continue;
                }
                TestStep testStep = result.getTestStep();
                if (!samplesMap.containsKey(testStep)) {
                    samplesMap.put(testStep, new TestSample(testStep));
                }
                ((TestSample)samplesMap.get(testStep)).addTestStepResult(result);
            }
            TestCase testCase = SamplesModel.this.loadTest.getTestCase();
            TestSample[] samples = new TestSample[testCase.getTestStepCount()];
            for (int c = 0; c < samples.length; ++c) {
                samples[c] = (TestSample)samplesMap.get(testCase.getTestStepAt(c));
            }
            SamplesModel.this.addSamples(samples);
        }
    }
}

