/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.assertions;

import com.eviware.soapui.config.LoadTestAssertionConfig;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.AbstractLoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.support.Configurable;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public class TestStepMaxAssertion
extends AbstractLoadTestAssertion
implements Configurable {
    private static final String NAME_FIELD = "Name";
    private static final String NAME_ELEMENT = "name";
    private static final String MAX_VALUE_ELEMENT = "max-value";
    private static final String MIN_REQUESTS_ELEMENT = "min-requests";
    private static final String MAX_VALUE_FIELD = "Max Time";
    private static final String MINIMUM_REQUESTS_FIELD = "Minimum Requests";
    private static final String MAX_ERRORS_ELEMENT = "max-errors";
    private static final String MAX_ERRORS_FIELD = "Max Errors";
    private int minRequests;
    private int maxValue;
    private int maxErrors;
    private XFormDialog dialog;
    public static final String STEP_MAXIMUM_TYPE = "Step Maximum";
    private static final Logger log = Logger.getLogger(TestStepMaxAssertion.class);

    public TestStepMaxAssertion(LoadTestAssertionConfig assertionConfig, WsdlLoadTest loadTest) {
        super(assertionConfig, loadTest);
        this.init(assertionConfig);
        this.initIcon("/max_loadtest_assertion.gif");
    }

    private void init(LoadTestAssertionConfig assertionConfig) {
        XmlObject configuration = assertionConfig.getConfiguration();
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(configuration);
        this.setName(reader.readString(NAME_ELEMENT, STEP_MAXIMUM_TYPE));
        this.minRequests = reader.readInt(MIN_REQUESTS_ELEMENT, 100);
        this.maxValue = reader.readInt(MAX_VALUE_ELEMENT, 1000);
        this.setTargetStep(reader.readString("test-step", "- Any -"));
        this.maxErrors = reader.readInt(MAX_ERRORS_ELEMENT, -1);
    }

    public String assertResult(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestStepResult result, TestRunner testRunner, TestRunContext runContext) {
        TestStep step = result.getTestStep();
        if (this.targetStepMatches(step)) {
            WsdlLoadTest loadTest = (WsdlLoadTest)loadTestRunner.getLoadTest();
            LoadTestStatistics statisticsModel = loadTest.getStatisticsModel();
            int index = step.getTestCase().getIndexOfTestStep(step);
            long maximum = result.getTimeTaken();
            if (statisticsModel.getStatistic(index, LoadTestStatistics.Statistic.COUNT) > (long)this.minRequests && maximum >= (long)this.maxValue) {
                return this.returnErrorOrFail("Time [" + maximum + "] exceeds limit [" + this.maxValue + "]", this.maxErrors, loadTestRunner, context);
            }
        }
        return null;
    }

    public String assertResults(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext) {
        if ("- Total -".equals(this.getTargetStep())) {
            WsdlLoadTest loadTest = (WsdlLoadTest)loadTestRunner.getLoadTest();
            LoadTestStatistics statisticsModel = loadTest.getStatisticsModel();
            long sum = 0L;
            List<TestStepResult> results = testRunner.getResults();
            for (int c = 0; c < results.size(); ++c) {
                TestStepResult result = results.get(c);
                if (result == null) {
                    log.warn((Object)("Result [" + c + "] is null in TestCase [" + testRunner.getTestCase().getName() + "]"));
                    continue;
                }
                sum += result.getTimeTaken();
            }
            if (statisticsModel.getStatistic(-1, LoadTestStatistics.Statistic.COUNT) >= (long)this.minRequests && sum >= (long)this.maxValue) {
                return this.returnErrorOrFail("Time [" + sum + "] exceeds limit [" + this.maxValue + "]", this.maxErrors, loadTestRunner, context);
            }
        }
        return null;
    }

    public String getDescription() {
        return "testStep: " + this.getTargetStep() + ", minRequests: " + this.minRequests + ", maxValue: " + this.maxValue + ", maxErrors: " + this.maxErrors;
    }

    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(NAME_FIELD, this.getName());
        values.put(MINIMUM_REQUESTS_FIELD, String.valueOf(this.minRequests));
        values.put(MAX_VALUE_FIELD, String.valueOf(this.maxValue));
        values.put("TestStep", this.getTargetStep());
        values.put(MAX_ERRORS_FIELD, String.valueOf(this.maxErrors));
        this.dialog.setOptions("TestStep", this.getTargetStepOptions(true));
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            try {
                this.minRequests = Integer.parseInt((String)values.get(MINIMUM_REQUESTS_FIELD));
                this.maxValue = Integer.parseInt((String)values.get(MAX_VALUE_FIELD));
                this.maxErrors = Integer.parseInt((String)values.get(MAX_ERRORS_FIELD));
                this.setTargetStep((String)values.get("TestStep"));
                this.setName((String)values.get(NAME_FIELD));
            }
            catch (Exception e) {
                UISupport.showErrorMessage(e.getMessage());
            }
            this.updateConfiguration();
            return true;
        }
        return false;
    }

    protected void updateConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(NAME_ELEMENT, this.getName());
        builder.add(MIN_REQUESTS_ELEMENT, this.minRequests);
        builder.add(MAX_VALUE_ELEMENT, this.maxValue);
        builder.add("test-step", this.getTargetStep());
        builder.add(MAX_ERRORS_ELEMENT, this.maxErrors);
        this.setConfiguration(builder.finish());
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("TestStep Max Assertion");
        XForm form = builder.createForm("Basic");
        form.addTextField(NAME_FIELD, "Name of this assertion", XForm.FieldType.TEXT);
        form.addTextField(MINIMUM_REQUESTS_FIELD, "Minimum steps before asserting", XForm.FieldType.TEXT);
        form.addTextField(MAX_VALUE_FIELD, "Maximum allowed step time", XForm.FieldType.TEXT);
        form.addTextField(MAX_ERRORS_FIELD, "Maximum number of errors before failing", XForm.FieldType.TEXT);
        form.addComboBox("TestStep", new String[0], "TestStep to assert");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/userguide/loadtest/assertions.html#Step_Maximum_Assertion"), "Specify options for this TestStep Max Assertion", UISupport.OPTIONS_ICON);
    }
}

