/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.assertions;

import com.eviware.soapui.config.LoadTestAssertionConfig;
import com.eviware.soapui.impl.wsdl.loadtest.LoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.AbstractLoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.MaxErrorsAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.TestStepAverageAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.TestStepMaxAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.TestStepStatusAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.TestStepTpsAssertion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoadTestAssertionRegistry {
    private static LoadTestAssertionRegistry instance;
    private Map<String, Class<? extends AbstractLoadTestAssertion>> availableAssertions = new HashMap<String, Class<? extends AbstractLoadTestAssertion>>();
    private static final Logger logger;

    public LoadTestAssertionRegistry() {
        this.availableAssertions.put("Step Average", TestStepAverageAssertion.class);
        this.availableAssertions.put("Step TPS", TestStepTpsAssertion.class);
        this.availableAssertions.put("Step Maximum", TestStepMaxAssertion.class);
        this.availableAssertions.put("Step Status", TestStepStatusAssertion.class);
        this.availableAssertions.put("Max Errors", MaxErrorsAssertion.class);
    }

    public static synchronized LoadTestAssertionRegistry getInstance() {
        if (instance == null) {
            instance = new LoadTestAssertionRegistry();
        }
        return instance;
    }

    public static AbstractLoadTestAssertion buildAssertion(LoadTestAssertionConfig config, WsdlLoadTest loadTest) {
        try {
            Class<? extends AbstractLoadTestAssertion> clazz = LoadTestAssertionRegistry.getInstance().availableAssertions.get(config.getType());
            Constructor<? extends AbstractLoadTestAssertion> ctor = clazz.getConstructor(LoadTestAssertionConfig.class, WsdlLoadTest.class);
            return ctor.newInstance(config, loadTest);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static LoadTestAssertionConfig createAssertionConfig(String type) {
        LoadTestAssertionConfig config = LoadTestAssertionConfig.Factory.newInstance();
        config.setType(type);
        return config;
    }

    public static String[] getAvailableAssertions() {
        return LoadTestAssertionRegistry.getInstance().availableAssertions.keySet().toArray(new String[LoadTestAssertionRegistry.getInstance().availableAssertions.size()]);
    }

    public static LoadTestAssertion createAssertion(String type, WsdlLoadTest loadTest) {
        LoadTestAssertionConfig config = LoadTestAssertionRegistry.createAssertionConfig(type);
        return LoadTestAssertionRegistry.buildAssertion(config, loadTest);
    }

    static {
        logger = Logger.getLogger(LoadTestAssertionRegistry.class);
    }
}

