/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testcase;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class TestCaseOptionsAction
extends AbstractAction {
    private static final String KEEP_SESSION = "Session";
    private static final String FAIL_ON_ERROR = "Abort on Error";
    private static final String FAIL_TESTCASE_ON_ERROR = "Fail TestCase on Error";
    private static final String DISCARD_OK_RESULTS = "Discard OK Results";
    private static final String SOCKET_TIMEOUT = "Socket timeout";
    private static final String SEARCH_PROPERTIES = "Search Properties";
    private final WsdlTestCase testCase;
    private XFormDialog dialog;
    private XForm form;

    public TestCaseOptionsAction(WsdlTestCase testCase) {
        super("Options");
        this.testCase = testCase;
        this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
        this.putValue("ShortDescription", "Sets options for this TestCase");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu shift O"));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("TestCase Options");
            this.form = builder.createForm("Basic");
            this.form.addCheckBox(SEARCH_PROPERTIES, "Search preceding teststeps for property values");
            this.form.addCheckBox(KEEP_SESSION, "Maintain HTTP session");
            this.form.addCheckBox(FAIL_ON_ERROR, "Fail on error").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    TestCaseOptionsAction.this.form.getFormField(TestCaseOptionsAction.FAIL_TESTCASE_ON_ERROR).setEnabled(!Boolean.parseBoolean(newValue));
                }
            });
            this.form.addCheckBox(FAIL_TESTCASE_ON_ERROR, "Fail TestCase if it has failed TestSteps");
            this.form.addCheckBox(DISCARD_OK_RESULTS, "Discards successfull testresults to preserve memory");
            this.form.addTextField(SOCKET_TIMEOUT, "Socket timeout in milliseconds", XForm.FieldType.TEXT);
            this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("http://www.soapui.org/userguide/functional/testcases.html#TestCase_Options"), "Specify general options for this TestCase", UISupport.OPTIONS_ICON);
        }
        StringToStringMap values = new StringToStringMap();
        values.put(SEARCH_PROPERTIES, String.valueOf(this.testCase.getSearchProperties()));
        values.put(KEEP_SESSION, String.valueOf(this.testCase.getKeepSession()));
        values.put(FAIL_ON_ERROR, String.valueOf(this.testCase.getFailOnError()));
        values.put(FAIL_TESTCASE_ON_ERROR, String.valueOf(this.testCase.getFailTestCaseOnErrors()));
        values.put(DISCARD_OK_RESULTS, String.valueOf(this.testCase.getDiscardOkResults()));
        values.put(SOCKET_TIMEOUT, String.valueOf(this.testCase.getSettings().getString(HttpSettings.SOCKET_TIMEOUT, "")));
        this.dialog.getFormField(FAIL_TESTCASE_ON_ERROR).setEnabled(!Boolean.parseBoolean(String.valueOf(this.testCase.getFailOnError())));
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            try {
                this.testCase.setSearchProperties(Boolean.parseBoolean((String)values.get(SEARCH_PROPERTIES)));
                this.testCase.setKeepSession(Boolean.parseBoolean((String)values.get(KEEP_SESSION)));
                this.testCase.setDiscardOkResults(Boolean.parseBoolean((String)values.get(DISCARD_OK_RESULTS)));
                this.testCase.setFailOnError(Boolean.parseBoolean((String)values.get(FAIL_ON_ERROR)));
                this.testCase.setFailTestCaseOnErrors(Boolean.parseBoolean((String)values.get(FAIL_TESTCASE_ON_ERROR)));
                String timeout = (String)values.get(SOCKET_TIMEOUT);
                if (timeout.trim().length() == 0) {
                    this.testCase.getSettings().clearSetting(HttpSettings.SOCKET_TIMEOUT);
                } else {
                    this.testCase.getSettings().setString(HttpSettings.SOCKET_TIMEOUT, timeout);
                }
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1.getMessage());
            }
        }
    }
}

