/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.request;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.support.AbstractAddToTestCaseAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestRequestStepFactory;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import java.awt.event.ActionEvent;

public class AddRequestToTestCaseAction
extends AbstractAddToTestCaseAction {
    private static final String STEP_NAME = "Name";
    private static final String ADD_SOAP_FAULT_ASSERTION = "Add Not SOAP Fault Assertion";
    private static final String ADD_SOAP_RESPONSE_ASSERTION = "Add SOAP Response Assertion";
    private static final String ADD_SCHEMA_ASSERTION = "Add Schema Assertion";
    private static final String CLOSE_REQUEST = "Close Request Window";
    private static final String SHOW_TESTCASE = "Shows TestCase Editor";
    private final WsdlRequest request;
    private XFormDialog dialog;
    private StringToStringMap dialogValues = new StringToStringMap();
    private XFormField closeRequestCheckBox;

    public AddRequestToTestCaseAction(WsdlRequest request) {
        super("Add to TestCase");
        this.request = request;
        this.putValue("ShortDescription", "Adds this request to a TestCase");
        this.putValue("SmallIcon", UISupport.createImageIcon("/addToTestCase.gif"));
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt A"));
    }

    public void actionPerformed(ActionEvent e) {
        WsdlProject project = this.request.getOperation().getInterface().getProject();
        WsdlTestCase testCase = this.getTargetTestCase(project);
        if (testCase != null) {
            this.addRequest(testCase);
        }
    }

    private boolean addRequest(WsdlTestCase testCase) {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.dialogValues.put(STEP_NAME, this.request.getOperation().getName() + " - " + this.request.getName());
        this.dialogValues.put(CLOSE_REQUEST, "true");
        this.dialogValues.put(SHOW_TESTCASE, "true");
        SoapUIDesktop desktop = SoapUI.getDesktop();
        this.closeRequestCheckBox.setEnabled(desktop != null && desktop.hasDesktopPanel(this.request));
        this.dialogValues = this.dialog.show(this.dialogValues);
        if (this.dialog.getReturnValue() != 1) {
            return false;
        }
        String name = (String)this.dialogValues.get(STEP_NAME);
        WsdlTestRequestStep test = (WsdlTestRequestStep)testCase.insertTestStep(WsdlTestRequestStepFactory.createConfig(this.request, name), -1);
        this.request.copyAttachmentsTo(test.getTestRequest());
        if (this.dialogValues.getBoolean(ADD_SOAP_RESPONSE_ASSERTION)) {
            test.getTestRequest().addAssertion("SOAP Response");
        }
        if (this.dialogValues.getBoolean(ADD_SCHEMA_ASSERTION)) {
            test.getTestRequest().addAssertion("Schema Compliance");
        }
        if (this.dialogValues.getBoolean(ADD_SOAP_FAULT_ASSERTION)) {
            test.getTestRequest().addAssertion("Not SOAP Fault");
        }
        UISupport.selectAndShow(test);
        if (this.dialogValues.getBoolean(CLOSE_REQUEST) && desktop != null) {
            desktop.closeDesktopPanel(this.request);
        }
        if (this.dialogValues.getBoolean(SHOW_TESTCASE)) {
            UISupport.selectAndShow(testCase);
        }
        return true;
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Add Request to TestCase");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addTextField(STEP_NAME, "Name of TestStep", XForm.FieldType.URL).setWidth(30);
        mainForm.addCheckBox(ADD_SOAP_RESPONSE_ASSERTION, "(adds validation that response is a SOAP message)");
        mainForm.addCheckBox(ADD_SCHEMA_ASSERTION, "(adds validation that response complies with its schema)");
        mainForm.addCheckBox(ADD_SOAP_FAULT_ASSERTION, "(adds validation that response is not a SOAP Fault)");
        this.closeRequestCheckBox = mainForm.addCheckBox(CLOSE_REQUEST, "(closes the current window for this request)");
        mainForm.addCheckBox(SHOW_TESTCASE, "(opens the TestCase editor for the target TestCase)");
        this.dialog = builder.buildDialog(builder.buildOkCancelActions(), "Specify options for adding the request to a TestCase", UISupport.OPTIONS_ICON);
        this.dialogValues.put(ADD_SOAP_RESPONSE_ASSERTION, Boolean.TRUE.toString());
    }
}

