/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockservice;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public class AddNewMockOperationAction
extends AbstractAction {
    private final WsdlMockService mockService;

    public AddNewMockOperationAction(WsdlMockService mockService) {
        super("New MockOperation");
        this.mockService = mockService;
        this.putValue("ShortDescription", "Creates a new MockOperation for this MockService");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu N"));
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<OperationWrapper> operations = new ArrayList<OperationWrapper>();
        for (int c = 0; c < this.mockService.getProject().getInterfaceCount(); ++c) {
            WsdlInterface iface = this.mockService.getProject().getInterfaceAt(c);
            for (int i = 0; i < iface.getOperationCount(); ++i) {
                if (this.mockService.hasMockOperation(iface.getOperationAt(i))) continue;
                operations.add(new OperationWrapper((WsdlOperation)iface.getOperationAt(i)));
            }
        }
        if (operations.isEmpty()) {
            UISupport.showErrorMessage("No unique operations to mock in project!");
            return;
        }
        Object result = UISupport.prompt("Select Operation to Mock", "New MockOperation", operations.toArray());
        if (result != null) {
            WsdlMockOperation mockOperation = this.mockService.addNewMockOperation(((OperationWrapper)result).getOperation());
            WsdlMockResponse mockResponse = mockOperation.addNewMockResponse("Response 1", true);
            UISupport.selectAndShow(mockResponse);
        }
    }

    public class OperationWrapper {
        private final WsdlOperation operation;

        public OperationWrapper(WsdlOperation operation) {
            this.operation = operation;
        }

        public WsdlOperation getOperation() {
            return this.operation;
        }

        public String toString() {
            return this.operation.getInterface().getName() + " - " + this.operation.getName();
        }
    }
}

