/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.wsi;

import com.eviware.soapui.support.DefaultHyperlinkListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.xmlbeans.XmlObject;

public class WSIReportPanel
extends JPanel {
    private File reportFile;
    private JEditorPane editorPane;
    private final String configFile;
    private final File logFile;

    public WSIReportPanel(File reportFile, String configFile, File logFile) throws Exception {
        super(new BorderLayout());
        this.reportFile = reportFile;
        this.configFile = configFile;
        this.logFile = logFile;
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildContent(), "Center");
    }

    private JComponent buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new SaveReportAction()));
        toolbar.addGlue();
        toolbar.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return toolbar;
    }

    private JComponent buildContent() throws Exception {
        JTabbedPane tabs = new JTabbedPane(3);
        this.editorPane = new JEditorPane();
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.editorPane.setEditable(false);
        this.editorPane.setPage(this.reportFile.toURL());
        this.editorPane.addHyperlinkListener(new DefaultHyperlinkListener(this.editorPane));
        JTextArea configContent = new JTextArea();
        configContent.setEditable(false);
        configContent.setText(this.configFile);
        tabs.addTab("Report", new JScrollPane(this.editorPane));
        tabs.addTab("Config", new JScrollPane(configContent));
        if (this.logFile != null) {
            String logFileContent = XmlObject.Factory.parse((File)this.logFile).toString();
            JTextArea logContent = new JTextArea();
            logContent.setEditable(false);
            logContent.setText(logFileContent);
            tabs.addTab("Log", new JScrollPane(logContent));
        }
        return UISupport.createTabPanel(tabs, true);
    }

    private class SaveReportAction
    extends AbstractAction {
        public SaveReportAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/export.gif"));
            this.putValue("ShortDescription", "Saves this report to a file");
        }

        public void actionPerformed(ActionEvent e) {
            File file = UISupport.getFileDialogs().saveAs(this, "Save Report", "html", "HTML files", null);
            if (file == null) {
                return;
            }
            try {
                FileWriter writer = new FileWriter(file);
                writer.write(WSIReportPanel.this.editorPane.getText());
                writer.close();
                UISupport.showInfoMessage("Report saved to [" + file.getAbsolutePath() + "]");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

