/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.iface.AbstractSwingAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.event.ActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateMockServiceAction
extends AbstractSwingAction<WsdlInterface> {
    private static final String CREATE_MOCKSUITE_OPTION = "<create>";

    public GenerateMockServiceAction(WsdlInterface iface) {
        super("Generate MockService", "Generates a MockService containing all Operations in this Interface", iface);
    }

    @Override
    public void actionPerformed(ActionEvent e, WsdlInterface iface) {
        this.generateMockService(iface);
    }

    public WsdlMockService generateMockService(WsdlInterface iface) {
        XFormDialog dialog = ADialogBuilder.buildDialog(Form.class);
        WsdlProject project = iface.getProject();
        Object[] mockServices = ModelSupport.getNames(project.getMockServices(), new String[]{CREATE_MOCKSUITE_OPTION});
        dialog.setOptions("MockService", mockServices);
        dialog.setValue("Path", "/mock" + iface.getName());
        dialog.setValue("Port", "8088");
        if (dialog.show()) {
            String mockServiceName = dialog.getValue("MockService");
            WsdlMockService mockService = project.getMockServiceByName(mockServiceName);
            if (mockService == null || mockServiceName.equals(CREATE_MOCKSUITE_OPTION)) {
                mockServiceName = UISupport.prompt("Specify name of MockService to create", this.getName(), iface.getName() + " MockService");
                if (mockServiceName == null) {
                    return null;
                }
                mockService = project.addNewMockService(mockServiceName);
            }
            mockService.setPath(dialog.getValue("Path"));
            try {
                mockService.setPort(Integer.parseInt(dialog.getValue("Port")));
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
            for (int i = 0; i < iface.getOperationCount(); ++i) {
                WsdlOperation operation = iface.getOperationAt(i);
                WsdlMockOperation mockOperation = mockService.addNewMockOperation(operation);
                mockOperation.addNewMockResponse("Response 1", true);
            }
            UISupport.showDesktopPanel(mockService);
            return mockService;
        }
        return null;
    }

    @AForm(name="Generate MockService", description="Set options for generated MockOperations for this Interface")
    private static interface Form {
        @AField(name="MockService", description="The MockService to create or use", type=AField.AFieldType.ENUMERATION)
        public static final String MOCKSERVICE = "MockService";
        @AField(name="Path", description="The URL path to mount on", type=AField.AFieldType.STRING)
        public static final String PATH = "Path";
        @AField(name="Port", description="The endpoint port to listen on", type=AField.AFieldType.STRING)
        public static final String PORT = "Port";
    }
}

