/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessagePart;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlAttachmentPart
extends MessagePart.AttachmentPart {
    public static final String ANONYMOUS_NAME = "<anonymous>";
    private String name;
    private List<String> contentTypes = new ArrayList<String>();
    private Attachment.AttachmentType type;
    private boolean anonymous;

    public WsdlAttachmentPart() {
        this.anonymous = true;
        this.name = ANONYMOUS_NAME;
    }

    public WsdlAttachmentPart(String name, List<String> types) {
        this.name = name;
        if (types != null) {
            this.contentTypes.addAll(types);
        }
    }

    public WsdlAttachmentPart(String name, String type) {
        this.name = name;
        if (type != null) {
            this.contentTypes.add(type);
        }
    }

    @Override
    public String[] getContentTypes() {
        return this.contentTypes.toArray(new String[this.contentTypes.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addContentType(String contentType) {
        this.contentTypes.add(contentType);
    }

    public Attachment.AttachmentType getAttachmentType() {
        return this.type;
    }

    public void setType(Attachment.AttachmentType type) {
        this.type = type;
    }

    @Override
    public String getDescription() {
        return this.name + " attachment; [" + this.getContentTypes() + "]";
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }
}

