/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.settings;

import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.HashSet;
import java.util.Set;

public class SettingsImpl
implements Settings {
    private final Settings parent;
    private final StringToStringMap values = new StringToStringMap();
    private final Set<SettingsListener> listeners = new HashSet<SettingsListener>();

    public SettingsImpl(Settings parent) {
        this.parent = parent;
    }

    public boolean isSet(String id) {
        return this.values.containsKey(id);
    }

    public String getString(String id, String defaultValue) {
        if (this.values.containsKey(id)) {
            return (String)this.values.get(id);
        }
        return this.parent == null ? defaultValue : this.parent.getString(id, defaultValue);
    }

    public void setString(String id, String value) {
        String oldValue = this.getString(id, null);
        this.values.put(id, value);
        for (SettingsListener listener : this.listeners) {
            listener.settingChanged(id, oldValue, value);
        }
    }

    public boolean getBoolean(String id) {
        if (this.values.containsKey(id)) {
            return Boolean.getBoolean((String)this.values.get(id));
        }
        return this.parent == null ? false : this.parent.getBoolean(id);
    }

    public void setBoolean(String id, boolean value) {
        String oldValue = this.getString(id, null);
        this.values.put(id, Boolean.toString(value));
        for (SettingsListener listener : this.listeners) {
            listener.settingChanged(id, oldValue, Boolean.toString(value));
        }
    }

    public long getLong(String id, long defaultValue) {
        if (this.values.containsKey(id)) {
            try {
                return Long.parseLong((String)this.values.get(id));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public void addSettingsListener(SettingsListener listener) {
        this.listeners.add(listener);
    }

    public void removeSettingsListener(SettingsListener listener) {
        this.listeners.remove(listener);
    }

    public void clearSetting(String id) {
        this.values.remove(id);
    }
}

