/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.SaveAllProjectsAction;
import com.eviware.soapui.config.SoapuiWorkspaceDocumentConfig;
import com.eviware.soapui.config.WorkspaceProjectConfig;
import com.eviware.soapui.impl.actions.ImportWsdlProjectAction;
import com.eviware.soapui.impl.actions.NewWsdlProjectAction;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceListener;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;

public class WorkspaceImpl
extends AbstractModelItem
implements Workspace {
    private static final Logger log = Logger.getLogger(WorkspaceImpl.class);
    private List<Project> projectList = new ArrayList<Project>();
    private SoapuiWorkspaceDocumentConfig workspaceConfig;
    private String path = null;
    private Set<WorkspaceListener> listeners = new HashSet<WorkspaceListener>();
    private ImageIcon workspaceIcon;
    private XmlBeansSettingsImpl settings;

    public WorkspaceImpl(String path) throws XmlException, IOException {
        this.path = path;
        File file = new File(path);
        if (file.exists()) {
            log.info((Object)("Loading workspace from [" + file.getAbsolutePath() + "]"));
            this.workspaceConfig = SoapuiWorkspaceDocumentConfig.Factory.parse((File)file);
            if (this.workspaceConfig.getSoapuiWorkspace().getSettings() == null) {
                this.workspaceConfig.getSoapuiWorkspace().addNewSettings();
            }
            this.settings = new XmlBeansSettingsImpl(this, SoapUI.getSettings(), this.workspaceConfig.getSoapuiWorkspace().getSettings());
            List projects = this.workspaceConfig.getSoapuiWorkspace().getProjectList();
            for (int i = 0; i < projects.size(); ++i) {
                WsdlProject project;
                WorkspaceProjectConfig wsc = (WorkspaceProjectConfig)projects.get(i);
                String str = wsc.getStringValue();
                if (new File(str).exists()) {
                    try {
                        project = new WsdlProject(str, this);
                        this.projectList.add(project);
                    }
                    catch (Exception e) {
                        UISupport.showErrorMessage("Failed to load project [" + str + "]\nfrom workspace; " + e.getMessage());
                        e.printStackTrace();
                    }
                    continue;
                }
                UISupport.showErrorMessage("project [" + str + "]\nnot found, disabling in workspace");
                try {
                    project = new WsdlProject(str, this, false);
                    this.projectList.add(project);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.workspaceConfig = SoapuiWorkspaceDocumentConfig.Factory.newInstance();
            this.workspaceConfig.addNewSoapuiWorkspace().setName("Default Workspace");
            this.workspaceConfig.getSoapuiWorkspace().addNewSettings();
            this.settings = new XmlBeansSettingsImpl(this, SoapUI.getSettings(), this.workspaceConfig.getSoapuiWorkspace().getSettings());
        }
        this.initActions();
        this.workspaceIcon = UISupport.createImageIcon("/workspace.gif");
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Project[] getProjects() {
        return this.projectList.toArray(new Project[this.projectList.size()]);
    }

    public void setName(String name) {
        this.workspaceConfig.getSoapuiWorkspace().setName(name);
    }

    public String getName() {
        return "Projects";
    }

    public Project getProjectAt(int index) {
        return this.projectList.get(index);
    }

    public Project getProjectByName(String projectName) {
        for (Project project : this.projectList) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        return null;
    }

    public int getProjectCount() {
        return this.projectList.size();
    }

    public void onClose() {
        this.save(false);
    }

    public void save(boolean workspaceOnly) {
        try {
            ArrayList<WorkspaceProjectConfig> projects = new ArrayList<WorkspaceProjectConfig>();
            for (int c = 0; c < this.getProjectCount(); ++c) {
                String path;
                WsdlProject project = (WsdlProject)this.getProjectAt(c);
                if (!workspaceOnly) {
                    project.save();
                }
                if ((path = project.getPath()) == null) continue;
                WorkspaceProjectConfig wpc = WorkspaceProjectConfig.Factory.newInstance();
                wpc.setStringValue(path);
                projects.add(wpc);
            }
            if (this.path == null) {
                File file = UISupport.getFileDialogs().saveAs(this, "Save workspace", ".xml", "XML Files (*.xml)", null);
                if (file == null) {
                    return;
                }
                this.path = file.getAbsolutePath();
            }
            this.workspaceConfig.getSoapuiWorkspace().setProjectArray(projects.toArray(new WorkspaceProjectConfig[projects.size()]));
            this.workspaceConfig.getSoapuiWorkspace().setSoapuiVersion("1.7.1");
            File workspaceFile = new File(this.path);
            this.workspaceConfig.save(workspaceFile);
            log.info((Object)("Saved workspace to [" + workspaceFile.getAbsolutePath() + "]"));
        }
        catch (IOException e) {
            log.error((Object)("Failed to save workspace: " + e.getMessage()), (Throwable)e);
        }
    }

    private void initActions() {
        this.addAction(new NewWsdlProjectAction(this));
        this.addAction(new ImportWsdlProjectAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new SaveAllProjectsAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/projects.html"));
    }

    public void addWorkspaceListener(WorkspaceListener listener) {
        this.listeners.add(listener);
    }

    public void removeWorkspaceListener(WorkspaceListener listener) {
        this.listeners.remove(listener);
    }

    public Project importProject(String fileName) throws SoapUIException {
        File projectFile = new File(fileName);
        WsdlProject project = new WsdlProject(projectFile.getAbsolutePath(), this);
        this.projectList.add(project);
        for (WorkspaceListener listener : this.listeners) {
            listener.projectAdded(project);
        }
        this.save(true);
        return project;
    }

    public WsdlProject createProject(String name) throws SoapUIException {
        File projectFile = new File(this.createProjectFileName(name));
        File file = UISupport.getFileDialogs().saveAs(this, "Create Project", ".xml", "XML Files (*.xml)", projectFile);
        if (file == null) {
            return null;
        }
        return (WsdlProject)this.createProject(name, file);
    }

    public Project createProject(String name, File file) throws SoapUIException {
        File projectFile = file;
        block2: while (projectFile.exists()) {
            Boolean result = Boolean.FALSE;
            while (!result.booleanValue()) {
                result = UISupport.confirmOrCancel("Project File exists, overwrite?", "Overwrite Project?");
                if (result == null) {
                    return null;
                }
                if (result.booleanValue()) {
                    projectFile.delete();
                    continue;
                }
                projectFile = UISupport.getFileDialogs().saveAs(this, "Create Project", ".xml", "XML Files (*.xml)", projectFile);
                if (projectFile != null) continue block2;
                return null;
            }
        }
        WsdlProject project = new WsdlProject(projectFile.getAbsolutePath(), this);
        project.setName(name);
        this.projectList.add(project);
        for (WorkspaceListener listener : this.listeners) {
            listener.projectAdded(project);
        }
        try {
            project.save();
        }
        catch (IOException e) {
            log.error((Object)("Failed to save project: " + e.getMessage()), (Throwable)e);
        }
        this.save(true);
        return project;
    }

    private String createProjectFileName(String name) {
        StringBuffer result = new StringBuffer();
        result.append(name);
        result.append("-soapui-project.xml");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProject(Project project) {
        int ix = this.projectList.indexOf(project);
        if (ix == -1) {
            throw new RuntimeException("Project [" + project.getName() + "] not available in workspace for removal");
        }
        this.projectList.remove(ix);
        try {
            this.fireProjectRemoved(project);
        }
        finally {
            project.release();
            this.workspaceConfig.getSoapuiWorkspace().removeProject(ix);
        }
    }

    public void reloadProject(WsdlProject project) throws SoapUIException {
        int ix = this.projectList.indexOf(project);
        if (ix == -1) {
            throw new RuntimeException("Project [" + project.getName() + "] not available in workspace for removal");
        }
        this.projectList.remove(ix);
        this.fireProjectRemoved(project);
        project.release();
        project = new WsdlProject(project.getPath(), this);
        this.projectList.add(ix, project);
        for (WorkspaceListener listener : this.listeners) {
            listener.projectAdded(project);
        }
        this.workspaceConfig.getSoapuiWorkspace().getProjectArray(ix).setStringValue(project.getPath());
        this.save(true);
    }

    private void fireProjectRemoved(Project project) {
        WorkspaceListener[] listenerArray = this.listeners.toArray(new WorkspaceListener[this.listeners.size()]);
        for (int c = 0; c < listenerArray.length; ++c) {
            listenerArray[c].projectRemoved(project);
        }
    }

    public ImageIcon getIcon() {
        return this.workspaceIcon;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public int getIndexOfProject(Project project) {
        return this.projectList.indexOf(project);
    }

    public String getPath() {
        return this.path;
    }

    public void release() {
        this.settings.release();
        for (Project project : this.projectList) {
            project.release();
        }
    }

    public int hashCode() {
        return this.getPath().hashCode() + this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Workspace)) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return workspace.hashCode() == this.hashCode();
    }
}

