/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.ui.desktop.DesktopRegistry;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.l2fprod.common.swing.JFontChooser;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class UIPrefs
implements Prefs {
    public static final String ORDER_PROJECTS = "Order Projects";
    public static final String ORDER_TESTCASES = "Order TestCases";
    public static final String ORDER_REQUESTS = "Order Requests";
    public static final String NO_RESIZE_REQUEST_EDITOR = "Disable auto-resize";
    public static final String START_WITH_REQUEST_TABS = "Tabbed request view";
    public static final String AUTO_VALIDATE_REQUEST = "Validate Requests";
    public static final String ABORT_ON_INVALID_REQUEST = "Abort on invalid";
    public static final String AUTO_VALIDATE_RESPONSE = "Validate Responses";
    public static final String CREATE_BACKUP = "Create Backup";
    public static final String BACKUP_FOLDER = "Backup Folder";
    public static final String DESKTOP_TYPE = "Desktop Type";
    public static final String NATIVE_LAF = "Native L&F";
    public static final String ENABLE_GROOVY_LOG_DURING_LOADTEST = "Do not disable Groovy Log";
    private JTextField editorFontTextField;
    private SimpleForm editorForm;
    private final String title;
    private JCheckBox abortCheckBox;
    private JCheckBox autoValidateCheckBox;
    private JCheckBox backupCheckBox;
    private JTextField backupFolder;

    public UIPrefs(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public SimpleForm getForm() {
        if (this.editorForm == null) {
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.editorFontTextField = new JTextField(20);
            this.editorFontTextField.setEnabled(false);
            builder.addFixed((JComponent)this.editorFontTextField);
            builder.addRelatedGap();
            builder.addFixed((JComponent)new JButton(new AbstractAction("Select Font.."){

                public void actionPerformed(ActionEvent e) {
                    Font font = JFontChooser.showDialog(null, (String)"Select XML Editor Font", (Font)Font.decode(UIPrefs.this.editorFontTextField.getText()));
                    if (font != null) {
                        UIPrefs.this.editorFontTextField.setText(font.getFontName() + "-plain-" + font.getSize());
                    }
                }
            }));
            this.editorForm = new SimpleForm();
            this.editorForm.addSpace(5);
            this.editorForm.append("Editor Font", builder.getPanel());
            this.editorForm.addSpace(5);
            this.editorForm.appendCheckBox(ORDER_PROJECTS, "(orders projects alphabetically in tree)", false);
            this.editorForm.appendCheckBox(ORDER_TESTCASES, "(orders testcases alphabetically in tree)", false);
            this.editorForm.appendCheckBox(ORDER_REQUESTS, "(orders requests alphabetically in tree)", false);
            this.editorForm.appendSeparator();
            this.editorForm.appendCheckBox(NO_RESIZE_REQUEST_EDITOR, "(disables automatic resizing of request editors)", true);
            this.editorForm.appendCheckBox(START_WITH_REQUEST_TABS, "(defaults the request editor to the tabbed layout)", true);
            this.editorForm.appendSeparator();
            this.autoValidateCheckBox = this.editorForm.appendCheckBox(AUTO_VALIDATE_REQUEST, "(always validate request messages before they are sent)", true);
            this.abortCheckBox = this.editorForm.appendCheckBox(ABORT_ON_INVALID_REQUEST, "(aborts invalid requests)", true);
            this.editorForm.appendCheckBox(AUTO_VALIDATE_RESPONSE, "(always validate response messages)", true);
            this.autoValidateCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UIPrefs.this.abortCheckBox.setEnabled(UIPrefs.this.autoValidateCheckBox.isSelected());
                }
            });
            this.editorForm.appendSeparator();
            this.backupCheckBox = this.editorForm.appendCheckBox(CREATE_BACKUP, "(backup project files before they are saved)", true);
            this.backupFolder = this.editorForm.appendTextField(BACKUP_FOLDER, "(folder to backup to, can be both relative or absolut)");
            this.backupCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UIPrefs.this.backupFolder.setEnabled(UIPrefs.this.backupCheckBox.isSelected());
                }
            });
            if (SoapUI.isStandalone()) {
                this.editorForm.appendSeparator();
                this.editorForm.appendComboBox(DESKTOP_TYPE, DesktopRegistry.getInstance().getNames(), "Select the type of desktop to use");
                this.editorForm.appendCheckBox(NATIVE_LAF, "(use native Look & Feel - requires restart)", true);
            }
            this.editorForm.appendSeparator();
            this.editorForm.appendCheckBox(ENABLE_GROOVY_LOG_DURING_LOADTEST, "(do not disable the groovy log when running LoadTests)", true);
        }
        return this.editorForm;
    }

    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        this.editorForm.getValues(values);
        this.storeValues(values, settings);
    }

    public void storeValues(StringToStringMap values, Settings settings) {
        if (this.editorFontTextField != null) {
            settings.setString(UISettings.EDITOR_FONT, this.editorFontTextField.getText());
        }
        settings.setBoolean(UISettings.ORDER_PROJECTS, values.getBoolean(ORDER_PROJECTS));
        settings.setBoolean(UISettings.ORDER_REQUESTS, values.getBoolean(ORDER_REQUESTS));
        settings.setBoolean(UISettings.ORDER_TESTCASES, values.getBoolean(ORDER_TESTCASES));
        settings.setBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR, values.getBoolean(NO_RESIZE_REQUEST_EDITOR));
        settings.setBoolean(UISettings.START_WITH_REQUEST_TABS, values.getBoolean(START_WITH_REQUEST_TABS));
        settings.setBoolean(UISettings.AUTO_VALIDATE_REQUEST, values.getBoolean(AUTO_VALIDATE_REQUEST));
        settings.setBoolean(UISettings.ABORT_ON_INVALID_REQUEST, values.getBoolean(ABORT_ON_INVALID_REQUEST));
        settings.setBoolean(UISettings.AUTO_VALIDATE_RESPONSE, values.getBoolean(AUTO_VALIDATE_RESPONSE));
        settings.setBoolean(UISettings.CREATE_BACKUP, values.getBoolean(CREATE_BACKUP));
        settings.setString(UISettings.BACKUP_FOLDER, (String)values.get(BACKUP_FOLDER));
        if (SoapUI.isStandalone()) {
            settings.setString(UISettings.DESKTOP_TYPE, (String)values.get(DESKTOP_TYPE));
            settings.setBoolean(UISettings.NATIVE_LAF, values.getBoolean(NATIVE_LAF));
        }
        settings.setBoolean(UISettings.DONT_DISABLE_GROOVY_LOG, values.getBoolean(ENABLE_GROOVY_LOG_DURING_LOADTEST));
    }

    public void setFormValues(Settings settings) {
        String editorFont = settings.getString(UISettings.EDITOR_FONT, "Courier plain 11");
        if (editorFont == null || editorFont.length() == 0) {
            editorFont = "Courier plain 11";
        }
        this.editorFontTextField.setText(editorFont);
        this.editorForm.setValues(this.getValues(settings));
        this.abortCheckBox.setEnabled(settings.getBoolean(UISettings.AUTO_VALIDATE_REQUEST));
        this.backupFolder.setEnabled(settings.getBoolean(UISettings.CREATE_BACKUP));
    }

    public StringToStringMap getValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        values.put(ORDER_PROJECTS, settings.getBoolean(UISettings.ORDER_PROJECTS));
        values.put(ORDER_REQUESTS, settings.getBoolean(UISettings.ORDER_REQUESTS));
        values.put(ORDER_TESTCASES, settings.getBoolean(UISettings.ORDER_TESTCASES));
        values.put(NO_RESIZE_REQUEST_EDITOR, settings.getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR));
        values.put(START_WITH_REQUEST_TABS, settings.getBoolean(UISettings.START_WITH_REQUEST_TABS));
        values.put(AUTO_VALIDATE_REQUEST, settings.getBoolean(UISettings.AUTO_VALIDATE_REQUEST));
        values.put(ABORT_ON_INVALID_REQUEST, settings.getBoolean(UISettings.ABORT_ON_INVALID_REQUEST));
        values.put(AUTO_VALIDATE_RESPONSE, settings.getBoolean(UISettings.AUTO_VALIDATE_RESPONSE));
        values.put(CREATE_BACKUP, settings.getBoolean(UISettings.CREATE_BACKUP));
        values.put(BACKUP_FOLDER, settings.getString(UISettings.BACKUP_FOLDER, ""));
        if (SoapUI.isStandalone()) {
            values.put(DESKTOP_TYPE, settings.getString(UISettings.DESKTOP_TYPE, "Windows"));
            values.put(NATIVE_LAF, settings.getBoolean(UISettings.NATIVE_LAF));
        }
        values.put(ENABLE_GROOVY_LOG_DURING_LOADTEST, settings.getBoolean(UISettings.DONT_DISABLE_GROOVY_LOG));
        return values;
    }
}

