/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse.element;

import org.apache.xml.security.utils.XMLUtils;
import org.jboss.ws.wsse.Util;
import org.jboss.ws.wsse.WSSecurityException;
import org.jboss.ws.wsse.element.Token;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UsernameToken
implements Token {
    private String username;
    private String password;
    private Document doc;
    private String id;
    private Element cachedElement;

    public UsernameToken(String username, String password, Document doc) {
        this.username = username;
        this.password = password;
        this.doc = doc;
    }

    public UsernameToken(Element element) throws WSSecurityException {
        this.doc = element.getOwnerDocument();
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() == 0) {
            throw new WSSecurityException("Invalid message, UsernameToken is missing an id");
        }
        this.setId(id);
        Element child = Util.getFirstChildElement(element);
        if (child == null || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI()) || !"Username".equals(child.getLocalName())) {
            throw new WSSecurityException("Username child expected in UsernameToken element");
        }
        this.username = XMLUtils.getFullTextChildrenFromElement((Element)child);
        if ((child = Util.getNextSiblingElement(child)) == null || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI()) || !"Password".equals(child.getLocalName())) {
            throw new WSSecurityException("Password child expected in UsernameToken element");
        }
        this.password = XMLUtils.getFullTextChildrenFromElement((Element)child);
    }

    public String getId() {
        if (this.id == null) {
            this.id = Util.generateId("token");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:UsernameToken");
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", this.getId());
        Element child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Username");
        child.appendChild(this.doc.createTextNode(this.username));
        element.appendChild(child);
        child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Password");
        child.appendChild(this.doc.createTextNode(this.password));
        element.appendChild(child);
        this.cachedElement = element;
        return this.cachedElement;
    }

    public Object getUniqueContent() {
        return null;
    }
}

