/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Font;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.jboss.seam.pdf.ui.UIDocument;
import org.jboss.seam.pdf.ui.UIFont;
import org.jboss.seam.ui.JSF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ITextComponent
extends UIComponentBase {
    public static final String COMPONENT_FAMILY = "org.jboss.seam.pdf";
    protected String inFacet;
    protected Object currentFacet;

    public abstract Object getITextObject();

    public abstract void createITextObject(FacesContext var1);

    public abstract void removeITextObject();

    public abstract void handleAdd(Object var1);

    public final void add(Object other) {
        if (this.inFacet != null) {
            this.handleFacet(this.inFacet, other);
        } else {
            this.handleAdd(other);
        }
    }

    public void handleFacet(String facetName, Object obj) {
        this.currentFacet = obj;
    }

    public Font getFont() {
        UIFont fontComponent = (UIFont)this.findITextParent((UIComponent)this, UIFont.class);
        return fontComponent == null ? null : fontComponent.getFont();
    }

    public Document findDocument() {
        ITextComponent parent = this.findITextParent((UIComponent)this, UIDocument.class);
        if (parent != null) {
            return (Document)parent.getITextObject();
        }
        return null;
    }

    public ITextComponent findITextParent(UIComponent parent) {
        return this.findITextParent(parent, null);
    }

    public ITextComponent findITextParent(UIComponent parent, Class<?> c) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof ITextComponent && (c == null || c.isAssignableFrom(parent.getClass()))) {
            return (ITextComponent)parent;
        }
        return this.findITextParent(parent.getParent(), c);
    }

    public void addToITextParent(Object obj) {
        ITextComponent parent = this.findITextParent(this.getParent());
        if (parent == null) {
            throw new RuntimeException("Couldn't find ITextComponent parent for component " + ((Object)((Object)this)).getClass().getName());
        }
        parent.add(obj);
    }

    public Object processFacet(String facetName) {
        if (this.inFacet != null && this.inFacet.equals(facetName)) {
            return null;
        }
        UIComponent facet = this.getFacet(facetName);
        Object result = null;
        if (facet != null) {
            this.currentFacet = null;
            this.inFacet = facetName;
            try {
                this.encode(FacesContext.getCurrentInstance(), facet);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.inFacet = null;
                result = this.currentFacet;
                this.currentFacet = null;
            }
        }
        return result;
    }

    public Object valueBinding(FacesContext context, String property, Object defaultValue) {
        Object value = defaultValue;
        ValueBinding binding = this.getValueBinding(property);
        if (binding != null) {
            value = binding.getValue(context);
        }
        return value;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.createITextObject(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        Object obj = this.getITextObject();
        if (obj != null) {
            this.addToITextParent(this.getITextObject());
        }
        this.removeITextObject();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        for (UIComponent child : this.getChildren()) {
            if (child.getFamily().equals("facelets.LiteralText")) {
                String text = this.replaceEntities(this.extractText(context, child));
                Font font = this.getFont();
                Chunk chunk = null;
                chunk = font == null ? new Chunk(text) : new Chunk(text, this.getFont());
                this.add(chunk);
                continue;
            }
            this.encode(context, child);
        }
    }

    public String extractText(FacesContext context, UIComponent child) throws IOException {
        ResponseWriter response = context.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        ResponseWriter cachingResponseWriter = response.cloneWithWriter((Writer)stringWriter);
        context.setResponseWriter(cachingResponseWriter);
        JSF.renderChild((FacesContext)context, (UIComponent)child);
        context.setResponseWriter(response);
        return stringWriter.getBuffer().toString();
    }

    private String replaceEntities(String text) {
        StringBuffer buffer = new StringBuffer(text);
        this.replaceAll(buffer, "&quot;", "\"");
        return buffer.toString();
    }

    private void replaceAll(StringBuffer buffer, String original, String changeTo) {
        int pos;
        while ((pos = buffer.indexOf(original)) != -1) {
            buffer.replace(pos, pos + original.length(), changeTo);
        }
    }

    public void encode(FacesContext context, UIComponent component) throws IOException, FacesException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getChildCount() > 0) {
            if (component.getRendersChildren()) {
                component.encodeChildren(context);
            } else {
                for (UIComponent child : this.getChildren()) {
                    this.encode(context, child);
                }
            }
        }
        component.encodeEnd(context);
    }
}

