/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf;

import java.io.IOException;
import java.util.Map;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Manager;
import org.jboss.seam.pdf.DocumentData;
import org.jboss.seam.pdf.DocumentStore;
import org.jboss.seam.util.Parameters;

public class DocumentStoreServlet
extends HttpServlet {
    private static final long serialVersionUID = 5196002741557182072L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(true);
        Lifecycle.setPhaseId((PhaseId)PhaseId.INVOKE_APPLICATION);
        Lifecycle.setServletRequest((ServletRequest)request);
        Lifecycle.beginRequest((ServletContext)this.getServletContext(), (HttpSession)session, (ServletRequest)request);
        Manager.instance().restoreConversation(request.getParameterMap());
        Lifecycle.resumeConversation((HttpSession)session);
        Manager.instance().handleConversationPropagation(request.getParameterMap());
        try {
            this.doWork(request, response);
            Manager.instance().endRequest(ContextAdaptor.getSession((HttpSession)session));
            Lifecycle.endRequest((HttpSession)session);
        }
        catch (Exception e) {
            Lifecycle.endRequest();
            throw new ServletException((Throwable)e);
        }
        finally {
            Lifecycle.setServletRequest(null);
            Lifecycle.setPhaseId(null);
        }
    }

    private void doWork(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contentId = (String)Parameters.convertMultiValueRequestParameter((Map)Parameters.getRequestParameters(), (String)"docId", String.class);
        DocumentStore store = DocumentStore.instance();
        if (store.idIsValid(contentId)) {
            DocumentData documentData = store.getDocumentData(contentId);
            byte[] data = documentData.getData();
            response.setContentType(documentData.getDocType().getMimeType());
            response.setHeader("Content-Disposition", "inline; filename=\"" + documentData.getFileName() + "\"");
            if (data != null) {
                response.getOutputStream().write(data);
            }
        } else {
            String error = store.getErrorPage();
            if (error != null) {
                if (error.startsWith("/")) {
                    error = request.getContextPath() + error;
                }
                response.sendRedirect(error);
            } else {
                response.sendError(404);
            }
        }
    }
}

