/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.utils;

import java.util.Set;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.namespace.QName;

public class MimeUtils {
    public static QName convertMimeTypeToXmlType(String mimeType) {
        StringBuilder mimeName = new StringBuilder(mimeType);
        int pos = mimeName.indexOf("/");
        if (pos == -1) {
            return null;
        }
        mimeName.setCharAt(pos, '_');
        return new QName("http://www.jboss.org/jbossws/attachment/mimetype", mimeName.toString());
    }

    public static String getBaseMimeType(String mimeType) {
        ContentType contentType;
        if (mimeType == null) {
            return null;
        }
        try {
            contentType = new ContentType(mimeType);
        }
        catch (ParseException e) {
            return null;
        }
        return contentType.getBaseType();
    }

    public static boolean isMemberOf(String mimeType, Set mimeTypes) {
        if (mimeTypes.contains(mimeType)) {
            return true;
        }
        try {
            if (mimeTypes.contains(new ContentType(mimeType).getPrimaryType() + "/*")) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }
}

